/* ProgressBar.java
 * 
 * kAWT version 0.9951
 *
 * Copyright (C) 1999-2001 by 
 * Michael Kroll & Stefan Haustein GbR, Muelheim an der Ruhr GERMANY
 *
 * Contact: kawt@kawt.de
 * General Information about kAWT is available at: http://www.kawt.de
 *
 * Using kAWT for private and educational and in GPLed open source
 * projects is free. For other purposes, a commercial license must be
 * obtained. There is absolutely no warranty for non-commercial use.
 *
 *
 * 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *    SERVICING, REPAIR OR CORRECTION.
 *   
 * 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *   
 *    END OF TERMS AND CONDITIONS
 * 
 */


package de.kawt;

import java.awt.*;
import java.awt.event.*;


public class ProgressBar extends Component {
    
    int currentValue = 0;
    int maxValue;

    
    public ProgressBar () {
	maxValue = 100;
    }

    
    public ProgressBar (int maxValue) {
	this.maxValue = maxValue;
    }
    

    public void setValue (int currentValue) {
	this.currentValue = currentValue;
    }  

    
    public void setMax (int maxValue) {
	this.maxValue = maxValue;
    }

    
    public Dimension getPreferredSize () {
	return new Dimension (100, 20);
    }

    
    public Dimension getMinimumSize () {
	return new Dimension (10, 10);
    }

    
    public void paint (Graphics g) {
	
	Dimension dim = getSize ();
	int progressPosition = (dim.width-4) * currentValue / maxValue;
	
	g.setColor (Color.black);	
	g.drawRect (0, 0, dim.width-1, dim.height-1);
	
	g.setColor (Color.white);
	g.drawRect (1, 1, dim.width-3, dim.height-3);
	
	g.setColor (SystemColor.activeCaption);
	
	g.fillRect (2, 2, progressPosition, dim.height-4);
	g.setColor (Color.white);
	g.fillRect (progressPosition + 2, 2, dim.width - progressPosition - 4, dim.height-4);
    }
}


/*
 * $Log: ProgressBar.java,v $
 * Revision 1.2  2001/08/23 19:32:32  mkroll
 * Removed the paint (getGraphics ()); call from setValue().
 * ProgressBar is derived from Component now.
 *
 */
