/*
 * ColorDemo version 0.95
 *
 * Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
 *
 * Contact: kawt@kawt.de
 * General Information about kAWT is available at: http://www.kawt.de
 *
 * Using kAWT for private and educational and in GPLed open source
 * projects is free. For other purposes, a commercial license must be
 * obtained. There is absolutely no warranty for non-commercial use.
 *
 *
 * 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *    SERVICING, REPAIR OR CORRECTION.
 *   
 * 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *   
 *    END OF TERMS AND CONDITIONS
 */ 

import java.awt.*;
import java.awt.event.*;

class MemPanel extends Canvas {
    
    public void paint (Graphics g) {
	
	Dimension d = getSize ();
	
	int m = d.width > d.height ? d.height : d.width;
	int step = m / 10; 
	m = step * 10;
	
	g.setColor (new Color (127, 127, 127));
	g.fillRect (0, 0, d.width, d.height);
	
	g.setColor (Color.white);
	
	for (int i = step/2; i < d.width; i+= step)
	    g.drawLine (i, 0, i, d.height);
	
	for (int i = step/2; i < d.height; i+= step)
	    g.drawLine (0, i, d.width, i);
	
	g.translate ((d.width - m) / 2, (d.height - m) / 2);
	g.fillRect (step, step, 8*step, 8*step); 
	
	for (int i = 0; i < 8; i++) {
	    g.setColor (new Color (((i & 1) * 255) ,
				   ((i & 2) >> 1) * 255 ,
				   ((i & 4) >> 2) *255));
	    
	    g.fillRect ((i+1) * step, step, step, 2*step+step/2);
	    
	    int gray = 255 / 8 * i;
	    g.setColor (new Color (gray, gray, gray));
	    
	    g.fillRect ((i+1) * step, 3*step+step/2, step, step+step/2);
	    
	}
	
	g.setColor (Color.white);
	g.drawOval (0, 0, m, m);
	
	int ty = 6*step;
	
	g.setColor (Color.black);
	
	boolean small = m < 100;
	
	g.drawString 
	    ((small ? "ttl " : "total mem: ")
	     + Runtime.getRuntime().totalMemory(), 2*step, ty);
	
	g.drawString 
	    ((small ? "fr " : "free mem: ") 
	     + Runtime.getRuntime().freeMemory (), 2*step, ty+step);
	
	Runtime.getRuntime().gc();
	
	g.drawString 
	    ((small ? "gc " : "post gc: ")
	     +Runtime.getRuntime ().freeMemory (), 2*step, ty+2*step);
    }
    
    public Dimension getPreferredSize () {
	return new Dimension (160, 160);
    }
}

public class ColorDemo extends Frame implements ActionListener {
    
    ColorDemo () {
	setTitle ("kAWT Color Demo v0.97");
		
	Button exit = new Button ("Exit");
	exit.addActionListener (this);

	add ("Center", new MemPanel ());
	add ("South", exit);
	pack ();
    }
    
    public static void main (String [] argv) {
	new ColorDemo ().show ();
    }

    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("Exit")) {
	    System.exit (0);
	}
    } 

}
