
import java.io.*;
import javax.microedition.io.*;

import java.awt.*;
import java.awt.event.*;


public class ConnectorSample extends Frame implements ActionListener {

    TextField urlField = new TextField ();
    TextField sendField = new TextField ();
    List incoming = new List ();

    StreamConnection conn;
    InputStream in;
    OutputStream out;

    class Appender implements Runnable {
	String line;
	Appender (String line) {
	    this.line = line;
	}

	public void run () {
	    incoming.add (line);
	}
    }	    
	    
    class ReadThread extends Thread {

	public void run () {
	    
	    StringBuffer buf = new StringBuffer ();

	    while (true) {
		if (conn != null && in != null) {
		    try {
			int i = in.read ();
			if (i == 10) {
			    Toolkit.getDefaultToolkit ().getSystemEventQueue ()
				.invokeLater (new Appender (buf.toString ()));
	
			    buf.setLength (0);
			}
			else if (i > 31)
			    buf.append ((char) i);
		    }
		    catch (Exception e) {
			incoming.add (e.toString ());
			try {
			    in.close ();
			    out.close ();
			    conn.close ();
			} 
			catch (Exception e2) {}
			conn = null;
		    }
		}
	    }
	}
    }


    public ConnectorSample () {
	super ("ConnectorSample");

	addWindowListener (new de.kawt.Closer (null));
	
	Button connectButton = new Button ("connect");
	connectButton.addActionListener (this);

	Panel topPanel = new Panel (new BorderLayout ());
	//topPanel.add ("West", protocolChoice);
	topPanel.add ("Center", urlField);
	topPanel.add ("East", connectButton);

	Button sendButton = new Button ("send");
	sendButton.addActionListener (this);

	Panel bottomPanel = new Panel (new BorderLayout ());
	bottomPanel.add ("Center", sendField);
	bottomPanel.add ("East", sendButton);

	add ("North", topPanel);
	add ("Center", incoming);
	add ("South", bottomPanel);

	new ReadThread ().start ();

	pack ();
	show ();
    }

    public void actionPerformed (ActionEvent ae) {

	String cmd = ae.getActionCommand ();

	try {
	    if (cmd.equals ("send")) {
		out.write (sendField.getText ().getBytes ());
		out.write (13);
		out.write (10);
		out.flush ();
		sendField.setText ("");
	    }
	    else if (cmd.equals ("connect")) {
		if (conn != null) { 
		    in.close ();
		    out.close ();
		    conn.close ();
		    conn = null;
		}
		
	        conn = (StreamConnection) Connector.open 
		    (urlField.getText (), Connector.READ_WRITE, true);

		out = conn.openOutputStream ();
		in = conn.openInputStream ();

		incoming.add ("opened: "+urlField.getText ());
	    }
	}
	catch (Exception e) {
	    incoming.add (e.toString ());
	}
    }

    public static void main (String [] args) {
	new ConnectorSample ();
    }
}
