// Authors: Stefan Haustein (SH), Michael Kroll (MK)
//

import java.awt.*;
import java.awt.event.*;
import de.kawt.*;

class LayoutPanel extends Panel implements ActionListener {
    
    LayoutManager saveBorder;
    Frame frame;
    
    LayoutPanel (Frame frame) {
	
	super (new BorderLayout ());
	this.frame = frame;
	addButton ("North", "grid");
	addButton ("West", "exit");
	addButton ("Center", "dialog");
	addButton ("East", "flow");
	addButton ("South", "border");
	saveBorder = getLayout ();
	validate ();
    }


    void addButton (String where, String label) {
	Button b = new Button (label);
	add (where, b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
                     

    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("grid")) 
	    setLayout (new GridLayout (3, 2));
	else if (cmd.equals ("flow"))
	    setLayout (new FlowLayout ());
	else if (cmd.equals ("border"))
	    setLayout (saveBorder);
	else if (cmd.equals ("dialog")) {
	    if (OptionDialog.showConfirmDialog 
		(frame, "Do you like kAWT?", "Sample Dialog") 
		== OptionDialog.NO_OPTION)
		OptionDialog.showInputDialog 
		    (frame, "Why don't you like it?");
	}
	else if (cmd.equals ("exit")) 
	    System.exit (0);
	validate ();
    }
}


/* moved to ColorSample ...

class MemPanel extends Canvas {

    public void paint (Graphics g) {

	Dimension d = getSize ();

	int m = d.width > d.height ? d.height : d.width;
	int step = m / 10; 
	m = step * 10;
	
	//int x0 = (d.width - step * 8) / 2;
	//int y0 = (d.width - step * 8) / 2;

	g.setColor (new Color (127, 127, 127));
	g.fillRect (0, 0, d.width, d.height);

	g.setColor (Color.white);

	for (int i = step/2; i < d.width; i+= step)
	    g.drawLine (i, 0, i, d.height);

	for (int i = step/2; i < d.height; i+= step)
	    g.drawLine (0, i, d.width, i);

	g.translate ((d.width - m) / 2, (d.height - m) / 2);
	g.fillRect (step, step, 8*step, 8*step); 

	for (int i = 0; i < 8; i++) {
	    g.setColor (new Color (((i & 1) * 255) ,
				 ((i & 2) >> 1) * 255 ,
				 ((i & 4) >> 2) *255));

	    g.fillRect ((i+1) * step, step, step, 2*step+step/2);
	    
	    int gray = 255 / 8 * i;
	    g.setColor (new Color (gray, gray, gray));

	    g.fillRect ((i+1) * step, 3*step+step/2, step, step+step/2);

	}
	    
	g.setColor (Color.white);
	g.drawOval (0, 0, m, m);

	int ty = 6*step;

	g.setColor (Color.black);

	boolean small = m < 100;

	g.drawString 
	    ((small ? "ttl " : "total mem: ")
	     + Runtime.getRuntime().totalMemory(), 2*step, ty);

	g.drawString 
	    ((small ? "fr " : "free mem: ") 
	     + Runtime.getRuntime().freeMemory (), 2*step, ty+step);

	Runtime.getRuntime().gc();

	g.drawString 
	    ((small ? "gc " : "post gc: ")
	     +Runtime.getRuntime ().freeMemory (), 2*step, ty+2*step);

	
    }

    public Dimension getPreferredSize () {
	return new Dimension (160, 160);
    }
}

*/


class MiscPanel extends Panel implements ActionListener, ItemListener { 
    Frame frame;
    Checkbox checkBox1;
    Checkbox checkBox2;
    Checkbox titlebox;
    TextField tf;

    MiscPanel (Frame frame) {
	super (new GridLayout (0, 1));
	this.frame = frame;
	CheckboxGroup group = new CheckboxGroup ();
	
	checkBox1 = new Checkbox ("Public text", group, false);
	checkBox1.addItemListener (this);
	checkBox2 = new Checkbox ("Hidden text", group, false);
	checkBox2.addItemListener (this);

	add (checkBox1); 
	add (checkBox2);

	titlebox = new Checkbox ("Show Frame Title", true);
	titlebox.addItemListener (this);
	add (titlebox);
	
	tf = new TextField ("Test");
	add (tf);

	Choice choice = new Choice ();
	choice.add ("red");
	choice.add ("green");
	choice.add ("blue");
	add (choice);
	addButton ("beep");
	addButton ("exit");
    }
    
    void addButton (String label) {
	Button b = new Button (label);
	add (b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
    
    public void itemStateChanged (ItemEvent ev) {
	
	if (ev.getSource () == titlebox) {

	    if (ev.getStateChange () == ev.SELECTED) 
		frame.setTitle ("kAWT Demo v0.99");
	    else 
		frame.setTitle (null);
	    frame.validate ();	
	}
	else if (ev.getStateChange () == ev.SELECTED) {
	    tf.setEchoChar (ev.getSource () == checkBox2 ? '*' : '\0');
	    tf.setText (tf.getText ());
	}
    }

    
    public void actionPerformed (ActionEvent ev) {
	if (ev.getActionCommand ().equals ("beep")) {
	    Toolkit.getDefaultToolkit ().beep ();
	}
	else System.exit (0);
    }
}

class ScrollbarPanel extends Panel implements ActionListener {

    ScrollbarPanel (Frame frame) {
	super (new BorderLayout ());

	Panel center = new Panel (new GridLayout (0, 2));

        java.awt.List list = new java.awt.List ();

	for (int i= 0; i < 16; i++)	
	    list.add ("item "+i);

	center.add (list);

	TextArea ta = new TextArea ();
	    
	ta.setText ("This is an example of a simple TextArea with automatic word wrapping in this text block and some hard line breaks below.\n01\n02\n03\n04\n05\n06\n07\n08\n09\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n20\n");
	
	center.add (ta);
	
	Button exitB = new Button ("exit");
	exitB.addActionListener (this);
	exitB.setActionCommand ("exit");
	add ("Center", center);
	add ("South", exitB);
	validate ();
    }
    

    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("exit")) 
	    System.exit (0);
    }
}

class Closer extends WindowAdapter {
    public void windowClosing (WindowEvent e) {
	System.exit (0);
    }
}

public class KawtDemo extends Frame implements ActionListener {
    Dialog dialog;
    TabbedPane tabPane;

    KawtDemo () {
	super ("kAWT Demo v0.99");

	MenuBar menuBar = new MenuBar ();
	Menu menu = new Menu ("About");
	MenuItem mi = new MenuItem ("About kAWT");
	mi.addActionListener (this);
	menu.add (mi);
       
	menu.add (new MenuItem ("An uselsess entry"));
	menuBar.add (menu);

	menu = new Menu ("Test");

	menuBar.add (menu);
	menu.add (new MenuItem ("Test 1"));
	menu.add (new MenuItem ("Test 2"));
	menu.add (new MenuItem ("Test 3"));
	setMenuBar (menuBar);


	tabPane = new TabbedPane();
	tabPane.addTab ("Layout", new LayoutPanel (this));
	//tabPane.addTab ("Color", new MemPanel ());
	tabPane.addTab ("Scroll", new ScrollbarPanel (this));
	tabPane.addTab ("Misc", new MiscPanel (this));
	add ("Center", tabPane);
	
	addWindowListener (new Closer ());
	pack ();
    }
    
    public static void main (String [] argv) {
	new KawtDemo ().show ();
    }

    public void actionPerformed (ActionEvent e) {
	OptionDialog.showMessageDialog 
	    (this, "KawtDemo is a sample kAWT application. For details about kAWT, please visit\nhttp://www.kawt.de");
    } 

}






