package de.kawt.impl;

import java.awt.*;

/** A simple and limited look-and-feel encapsulation class for kAWT. */

public class Laf {

    public static Laf laf;

    public static final int ARROW_UP = 1;
    public static final int ARROW_DOWN = 2;
    public static final int ARROW_LEFT = 3;
    public static final int ARROW_RIGHT = 4;

    public static final int CHOICE = 5;
    public static final int CHECKBOX = 6;
    public static final int RADIOBOX = 7;

    public static final int BORDER_NONE = 0;
    public static final int BORDER_SINGLE = 1;
    public static final int BORDER_DOUBLE = 2;
    public static final int BORDER_SHADOW = 3;
    public static final int BORDER_FOCUSABLE = 4;
    public static final int BORDER_FOCUSSED = 5;

    public static final int WINDOW_DIALOG = 0;
    public static final int WINDOW_FRAME = 1;
    

    public int buttonRadius = 1;
    public int scrollArrowSize = 0;


    public void drawButton (Graphics g, Color bg, 
                            int w, int h,
                            String label, 
                            boolean hasFocus, boolean pressing) {

        Color fg = g.getColor ();
        FontMetrics fm = g.getFontMetrics ();

        g.setColor (pressing ? SystemColor.activeCaption : bg);
        g.fillRoundRect (1, 1, w-2, h-2, 2, 2);
        g.setColor (fg);
        g.drawRoundRect (0, 0, w-1, h-1, 3, 3);
        g.setColor (pressing ? bg : fg);
        drawFocusString (g, bg, 
                         (w - fm.stringWidth (label))/2, 
                         (h - fm.getHeight ())/2,
                         label, hasFocus); 
    }

    public void drawFocusString (Graphics g, Color bg,  int x, int y, 
                                 String text, boolean hasFocus) {

        if (hasFocus) {
            FontMetrics fm = g.getFontMetrics ();
            g.fillRect (x, y, fm.stringWidth (text), fm.getHeight ());
            Color c = g.getColor ();
            g.setColor (bg);
            g.drawString (text, x, y+fm.getAscent ()); 
            g.setColor (c);
        }
        else g.drawString (text, x, y+g.getFontMetrics().getAscent ()); 
    }


    public void drawSymbol (Graphics g, Color bg, int x, int y, 
                            int type, boolean selected) {
        
        Color fg = g.getColor ();

        switch (type) {
        case ARROW_UP:
        case ARROW_DOWN:
            if (!selected) g.setColor (bg);
            g.fillRect (x, y++, 7, 6);
            g.setColor (selected ? bg : fg);
            
            if (type == ARROW_UP)
                for (int i = 3; i >= 0; i--) 
                    g.drawLine (x+i, y, x+6-i, y++);
            else 
                for (int i = 0; i < 4; i++) 
                    g.drawLine (x+i, y, x+6-i, y++);
            break;

        case ARROW_LEFT:
        case ARROW_RIGHT:
            if (!selected) g.setColor (bg);
            g.fillRect (x++, y, 6, 7);
            g.setColor (selected ? bg : fg);

            if (type == ARROW_LEFT)
                for (int i = 3; i >= 0; i--) 
                    g.drawLine (x, y+i, x++, y+6-i);
            else
                for (int i = 0; i < 4; i++) 
                    g.drawLine (x, y+i, x++, y+6-i);
            break;
        }

        g.setColor (fg);
    }



    public void drawWindow (Graphics g, int w, int h,
                            int type, String title, boolean focus) {

        if (type == WINDOW_FRAME) {
        
            if (title != null) {
                drawFocusString (g, Color.white, 0, 0, title, focus);
                g.drawLine (0, 8, 160, 8);
            }
        }
    }
    
    
    public void drawBorder (Graphics g, Color bg,
                            int w, int h, 
                            int style) {

        Color fg = g.getColor ();
        switch (style) {
        case BORDER_SHADOW: 
            g.drawLine (2, 1, w-4, 1);
            g.drawLine (2, h-3, w-3, h-3);
            g.drawLine (3, h-2, w-4, h-2);
            
            g.drawLine (1, 2, 1, h-4);
            g.drawLine (w-3, 2, w-3, h-3);
            g.drawLine (w-2, 3, w-2, h-4);
            break;

        case BORDER_FOCUSABLE:
            g.setColor (bg);
        case BORDER_FOCUSSED:
        case BORDER_DOUBLE:
            g.drawRect (1, 1, w-3, h-3);
            g.setColor (fg);
        case BORDER_SINGLE:
            g.drawRect (0, 0, w-1, h-1);
        }
    }

    /** size and position are measued in 1/1024 nds */

    public void drawScrollbar (Graphics g, Color bg, int w, int h, 
                               int orientation, int position, int size,
                               int scrollType, boolean focus) {

        Color fg = g.getColor ();
        g.setColor (bg);
        g.fillRect (0, 0, w, h);

        g.setColor (fg);
        
        if (orientation == Scrollbar.VERTICAL) {
            int m = w / 2;
            g.drawLine (m-1, 0, m+1, 0);
            g.drawLine (m-1, h-1, m+1, h-1);
            g.drawLine (m, 0, m, h);
            g.fillRect (m-1, position, 3, size);
        }
        else {
            int m = h / 2;
            g.drawLine (0, m-1, 0, m+1);
            g.drawLine (w-1, m-1, w-1, m+1);
            g.drawLine (0, m, w, m);
            g.fillRect (position, m-1, size, 3);
        }
    }


    public Dimension getMinimumButtonSize (FontMetrics fm, String label) {
        return new Dimension 
            (fm.stringWidth (label) + 4,
             fm.getHeight () + 2);
    }


    public Dimension getSymbolSize (int type) {
        return new Dimension (7, 7);
    }


    public Dimension getMinimumScrollbarSize (int orientation) {
        return orientation == Scrollbar.VERTICAL
            ? new Dimension (3*scrollArrowSize, 5)
                : new Dimension (5, 3*scrollArrowSize);
    }

    public Insets getWindowInsets (int type) {
        if (type == WINDOW_DIALOG) 
            return new Insets (10, 3, 3, 3);
        else
            return new Insets (10, 0, 0, 0);
    }

    public Insets getBorderInsets (int style) {
        
        switch (style) {
        case BORDER_SHADOW: return new Insets (2, 2, 3, 3);
        case BORDER_SINGLE: return new Insets (1, 1, 1, 1);
        case BORDER_FOCUSABLE:
        case BORDER_FOCUSSED:
        case BORDER_DOUBLE: return new Insets (2, 2, 2, 2);
        default:
            return new Insets (0, 0, 0, 0);
        }
    }

    

}
