// kAWT - Kilobyte Abstract Window Toolkit
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 

package de.kawt.impl.j2se;

import de.kawt.impl.*;
import javax.microedition.rms.*;
import java.util.*;
import java.io.*;


public class RecordStoreImpl extends AbstractRecordStore {

    private Vector records = new Vector ();
    private RandomAccessFile  raFile;
    private String fileName = "";
    private boolean storeOpen = false;

    
    public void initRecordMem (String recordStoreName, boolean createIfNotAvaliable) {
	this.fileName = recordStoreName;
	try {
	    raFile = new RandomAccessFile (fileName, "rw");
	    // records aus der Datei lesen
	    while (raFile.getFilePointer () < raFile.length ()) {
		int recLen = raFile.readInt ();
		byte[] data = new byte[recLen];
		raFile.read (data);
		records.add (data);
	    }
	} catch (IOException ioe) {
	    System.out.println ("ERROR in de.kawt.impl.RecordStoreImpl: " + ioe.toString ());
	}
	storeOpen = true;
    }


    private byte[] readRecord (int i) {
	return (byte[]) records.get (i);
    }


    private void writeRecord (byte [] data, int offset, int length)  {
	byte[] newData = new byte[length];
	System.arraycopy (data, offset, newData, 0, length);
	records.add (newData);
    }

    
    private void closeFile () {
	try {
	    raFile.setLength (0);
	    for (int i = 0; i < records.size (); i++) {
		byte[] data = (byte[])records.get (i);
		raFile.writeInt (data.length);
		raFile.write (data);
	    }
	    raFile.close ();
	} catch (IOException ioe) {
	    System.out.println ("ERROR in de.kawt.impl.RecordStoreImpl: " + ioe.toString ());
	}
	storeOpen = false;
    }


    /**
     *  Adds a new record to the record store.
     */
    public int addRecord (byte[] data, int offset, int numBytes) 
	throws RecordStoreNotOpenException,
	       RecordStoreException,
	       RecordStoreFullException {

	if (!storeOpen) { 
	    throw new RecordStoreNotOpenException ();
	} else {
	    writeRecord (data, offset, numBytes);
	    return records.size () -1;
	}
    }
    
    /**
     * Adds the specified RecordListener.
     */
    public void addRecordListener (RecordListener listener) {
	
    }
    
    /**
     * This method is called when the MIDlet requests to have the record store closed.
     */
    public void closeRecordStore ()
	throws RecordStoreNotOpenException,
	       RecordStoreException {
    
	closeFile ();
    }
    
    /**
     * The record is deleted from the record store.
     */
    public void deleteRecord (int recordId) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException {
	
	if (!storeOpen) { 
	    throw new RecordStoreNotOpenException ();
	} else {
	    if (recordId > records.size ()) 
		throw new InvalidRecordIDException ();
	    records.removeElementAt (recordId);
	    
	}
    }
    
    /**
     * Deletes the named record store.
     */
    public static void deleteRecordStore (String recordStoreName) 
	throws RecordStoreException,
	       RecordStoreNotFoundException {
    
    }
    
    /**     
     * Returns an enumeration for traversing a set of records in the record store in an optionally specified order.
     */
    //public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) {
    //return null;
    //}

    /**
     * Returns the last time the record store was modified, in the format used by System.currentTimeMillis().
     */
    public long getLastModified () throws RecordStoreNotOpenException {
	return 0;
    }

    /**
     * Returns the name of this RecordStore.
     */
    public String getName () throws RecordStoreNotOpenException {
	if (!storeOpen) {
	    throw new RecordStoreNotOpenException ();
	} else {
	    return fileName;
	}
    }
    
    /**
     * Returns the recordId of the next record to be added to the record store.
     */
    public int getNextRecordID () throws RecordStoreNotOpenException, RecordStoreException {
	return -1;
    }

    /**
     * Returns the number of records currently in the record store.
     */
    public int getNumRecords () throws RecordStoreNotOpenException {
	return records.size ();
    }

    /**
     * Returns a copy of the data stored in the given record.
     */
    public byte[] getRecord (int recordId) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException {

	return readRecord (recordId);
    }
    
    /**
     * Returns the data stored in the given record.
     */
    public int getRecord (int recordId, byte[] buffer, int offset) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException,
	       ArrayIndexOutOfBoundsException {

	return 0;
    }
    
    /**	
     * Returns the size (in bytes) of the application data available in the given record.
     */
    public int getRecordSize (int recordId) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException {
	
	return 0;
    }
    
    /**
     * Returns the amount of space, in bytes, that the record store occupies.
     */
    public int getSize () throws RecordStoreNotOpenException {
	return 0;
    }
    
    /**
     * Returns the amount of additional room (in bytes) available for this record store to grow.
     */
    public int getSizeAvailable () throws RecordStoreNotOpenException {
	return 0;
    }
    
    /**
     * Each time a record store is modified (record added, modified, deleted), it's version is incremented.
     */
    public int getVersion () throws RecordStoreNotOpenException {
	return 0;
    }
    
    /**
     * Returns an array of the names of record stores owned by the MIDlet suite.
     */
    public static String[] listRecordStores () {
	return null;
    }
    
    /**
     * Open (and possibly create) a record store associated with the given MIDlet suite.
     */
    public static RecordStore openRecordStore (String recordStoreName, boolean createIfNecessary) 
	throws RecordStoreException,
	       RecordStoreFullException,
	       RecordStoreNotFoundException {

	

	return null;
    }

    /**
     * Removes the specified RecordListener.
     */
    public void removeRecordListener (RecordListener listener) {
    }

    /**
     * Sets the data in the given record to that passed in.
     */
    public void setRecord (int recordId, byte[] newData, int offset, int numBytes) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException,
	       RecordStoreFullException {
    }
}
