// kAWT - Kilobyte Abstract Window Toolkit
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 

package de.kawt.impl.kjava;

import de.kawt.impl.*;
import javax.microedition.rms.*;
import com.sun.kjava.Database;
import java.io.*;

public class RecordStoreImpl extends AbstractRecordStore {
    
    Database stores;
    Database openedStore;

    int storesCreator = 0x4B524D53; // KRMS
    int storesType = getTypeIDInt("Strs");

    int openedCreator;
    int openedType;
    String openedName;


    public void initRecordMem (String recordStoreName, boolean createIfNotAvaliable) {
	
	stores = new com.sun.kjava.Database (storesType, storesCreator, com.sun.kjava.Database.READWRITE);
	  
	if (!stores.isOpen()) {
	    com.sun.kjava.Database.create (0, "kAWT-RmsStores", storesCreator, storesType, false);
	    stores = new com.sun.kjava.Database (storesType, storesCreator, com.sun.kjava.Database.READWRITE);
	}
	  
	// DB nach store durchsuchen.
	
	boolean found = false;
	int noOfRecs = stores.getNumberOfRecords ();
	for (int i = 0; i < noOfRecs; i++) {
	    byte[] buf = stores.getRecord (i);

	    openedCreator = getCreatorIDFromBuffer (buf);
	    openedType = getTypeIDFromBuffer (buf);
	    openedName = getDBNameFromBuffer (buf);
	    
	    if (recordStoreName.equals (openedName)) {
		found = true;
		break;
	    }
	}
	  
	if (found) {
	    openedStore = new com.sun.kjava.Database (openedType, openedCreator, com.sun.kjava.Database.READWRITE);  
	    if (!openedStore.isOpen()) {
		com.sun.kjava.Database.create (0, "kAWT-RS:"+recordStoreName, openedCreator, openedType, false);
	    }
	} 
	else {
	    String noOfStoresHex = Integer.toHexString (stores.getNumberOfRecords ());
	    String crString = "";
	    
	    if (noOfStoresHex.length () == 1) {
		crString = "000"+noOfStoresHex;
	    } 
	    else if (noOfStoresHex.length () == 2) {
		crString = "00"+noOfStoresHex;
	    } 
	    else if (noOfStoresHex.length () == 3) {
		crString = "0"+noOfStoresHex;
	    } 
	    else {
		crString = noOfStoresHex;
	    }

	    //System.out.println ("New Store TypeID <"+crString+"> created.");
	    
	    int cr = getTypeIDInt("KRMS");
	    int ty = getTypeIDInt(crString);

	    com.sun.kjava.Database.create (0, "kAWT-RS:"+recordStoreName, cr, ty, false);
	    openedStore = new com.sun.kjava.Database (ty, cr, com.sun.kjava.Database.READWRITE);  
	    
	    ByteArrayOutputStream baos = new ByteArrayOutputStream ();
	    baos.write (intToByteArray (cr), 0, 4);
	    baos.write (intToByteArray (ty), 0, 4);
	    baos.write (recordStoreName.getBytes (), 0, recordStoreName.length ());
	    stores.addRecord (baos.toByteArray()); 
	}
    }


    private int getCreatorIDFromBuffer (byte[] buffer) {
	return (((((int) buffer [0]) & 0x0ff) << 24)
		+ ((((int) buffer [1]) & 0x0ff) << 16)
		+ ((((int) buffer [2]) & 0x0ff) << 8)
		+ ((((int) buffer [3]) & 0x0ff)));
    }

    
    private int getTypeIDFromBuffer (byte[] buffer) {
	return (((((int) buffer [4]) & 0x0ff) << 24)
		+ ((((int) buffer [5]) & 0x0ff) << 16)
		+ ((((int) buffer [6]) & 0x0ff) << 8)
		+ ((((int) buffer [7]) & 0x0ff)));
    }
    
    private String getDBNameFromBuffer (byte[] buffer) {
	System.out.println ("DBbuffer = "+buffer.length );
	return new String (buffer, 8, buffer.length-8); 
    }


    private int getTypeIDInt(String typeID){
        return((typeID.charAt(0) << 24) +
	       (typeID.charAt(1) << 16) +
	       (typeID.charAt(2) <<  8) +
	       (typeID.charAt(3)));
    }


    private byte[] intToByteArray (int integer) {
	byte[] result = new byte[4];
	result [0] = (byte) ((integer >> 24) & 255);
	result [1] = (byte) ((integer >> 16) & 255);
	result [2] = (byte) ((integer >> 8) & 255);
	result [3] = (byte) (integer & 255);
	return result;
    }


    private byte[] readRecord (int i) {
	return openedStore.getRecord (i);
    }
    

    private void writeRecord (byte [] data, int offset, int length) {
	if (offset > 0) {
	    byte[] newData = new byte[length];
	    System.arraycopy (data, offset, newData, 0, length);
	    openedStore.addRecord (newData);
	}
	else {
	    openedStore.addRecord (data);
	}
    }

    
    private void closeDataBases () {
	if (stores.isOpen ()) {
	    stores.close ();
	}
	
	if (openedStore.isOpen ()) {
	    openedStore.close ();
	}
    }
    
    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/
    

    /**
     * Adds a new record to the record store.
     *
     * @param data The data to be stored in this record. If the record should
     *             have zero-length - no data - this parameter may be set to null
     * @param offset The index of the data buffer of the first databyte for this
     *               record
     * @return The recordid of the new record
     * @exception RecordStoreNotOpenException if the record store is not yet open.
     * @exception InvalidRecordIDException if the recordId is invalid.
     * @exception RecordStoreException if a general recordstoreexception occurs.
     */
    public int addRecord (byte[] data, int offset, int numBytes) 
	throws RecordStoreNotOpenException,
	       RecordStoreException,
	       RecordStoreFullException {

	if (openedStore == null)
	    throw new RecordStoreNotOpenException ();
	
	writeRecord (data, offset, numBytes);
	return openedStore.getNumberOfRecords () -1;
    }

    
    /**
     * Adds the specified RecordListener.
     * 
     * NOT YET IMPLEMENTED
     *
     * @param listener The RecordChangedListener
     */
    public void addRecordListener (RecordListener listener) {
	
    }

    
    /**
     * This method is called when the MIDlet requests to have the record store closed.
     *
     * @exception RecordStoreNotOpenException if the record store is not open
     * @exception RecordStoreException if another record store related Exception occurs
     */
    public void closeRecordStore ()
	throws RecordStoreNotOpenException,
	       RecordStoreException {
    
	if (stores == null || openedStore == null) {
	    throw new RecordStoreNotOpenException ();
	}
	  
	stores.close ();
	openedStore.close ();
    }

    
    /**
     * The record is deleted from the record store.
     *
     * NOT YET IMPLEMENTED
     *
     * @param recordId The ID of the record to be deleted
     * @exception RecordStoreNotOpenException if the record store is not open
     * @exception RecordStoreException if a different record store-related exception occurs
     */
    public void deleteRecord (int recordId) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException {
	
	if (openedStore == null) { 
	    throw new RecordStoreNotOpenException ();
	} else {
	    if (recordId > (openedStore.getNumberOfRecords ()-1)) 
		throw new InvalidRecordIDException ();
	    openedStore.deleteRecord (recordId);
	    
	}
	
    }

    
    /**
     * Deletes the named record store.
     *
     * @param recordStoreName The record store to be deleted 
     * @exception RecordStoreNotFoundException if the record store could not be found.
     * @exception RecordStoreException if a record store related exception occurs.
     */
    public static void deleteRecordStore (String recordStoreName) 
	throws RecordStoreException,
	       RecordStoreNotFoundException {
	throw new RecordStoreException ("kAWT: deleteRecordStore not implemented.");
    }

    
    /**     
     * Returns an enumeration for traversing a set of records in the record store in an optionally specified order.
     */
    //public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) {
    //return null;
    //}

    /**
     * Returns the last time the record store was modified, in the format used by System.currentTimeMillis().
     *
     * NOT YET IMPLEMENTED
     *
     * @return the last time the record store was modified, in the same format used by System.currentTimeMillis ();
     * @exception RecordStoreNotOpenException if the record store is not open.
     */
    public long getLastModified () throws RecordStoreNotOpenException {
	if (openedStore == null) { 
	    throw new RecordStoreNotOpenException ();
	} else {
	    return 0;	    	    
	}
    }


    /**
     * Returns the name of this RecordStore.
     * 
     * @return the name of this record store
     * @exception RecordStoreNotOpenException if the record store is not open.
     */
    public String getName () throws RecordStoreNotOpenException {
	if (openedStore == null)
	    throw new RecordStoreNotOpenException ();
	return openedName;
    }

    
    /**
     * Returns the recordId of the next record to be added to the record store.
     *
     * @return the recordId of the record store to be added to this record store.
     * @exception RecordStoreNotOpenException if the record store is not open.
     * @exception RecordStoreException if another record store related exception occurs
     */
    public int getNextRecordID () throws RecordStoreNotOpenException, RecordStoreException {
	if (openedStore == null) 
	    throw new RecordStoreNotOpenException ();
	
	return openedStore.getNumberOfRecords ()+1;
    }


    /**
     * Returns the number of records currently in the record store.
     *
     * @return the number of records currently in the opened record store
     * @exception RecordStoreNotOpenException if the record store is not open.
     */
    public int getNumRecords () throws RecordStoreNotOpenException {
	if (openedStore == null) 
	    throw new RecordStoreNotOpenException ();
	
	return openedStore.getNumberOfRecords ();
    }


    /**
     * Returns a copy of the data stored in the given record.
     *
     * @param recordId The ID of the record to use in this operation
     * @exception RecordStoreNotOpenException if the record store is not open.
     * @exception InvalidRecordIDException if the record store is invalid.
     * @exception RecordStoreException if a general record store exception occurs.
     */
    public byte[] getRecord (int recordId) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException {
	
	if (openedStore == null) 
	    throw new RecordStoreException ();
	
	if (recordId > (openedStore.getNumberOfRecords ()-1)) 
	    throw new InvalidRecordIDException ();
	
	return readRecord (recordId);
    }

    
    /**
     * Returns the data stored in the given record.
     *
     * @param recordId The ID of the record to be used in this operation.
     * @param buffer The byte array to copy the data.
     * @param offset The index index into the buffer i which to start copiying.
     * @return the number of bytes copied into the buffer, startting at index offset
     * @exception RecordStoreNotOpenException if the record store is not open.
     * @exception InvalidRecordIDException if the record store is invalid.
     * @exception RecordStoreException if a general record store exception occurs.
     * @exception ArrayIndexOutOfBoundsException if the record is larger that the buffer supplied
     */
    public int getRecord (int recordId, byte[] buffer, int offset) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException,
	       ArrayIndexOutOfBoundsException {
	
	return 0;
    }

    
    /**	
     * Returns the size (in bytes) of the application data available in the given record.
     *
     * @param recordId The ID of the record to be used in this operation.
     * @return the size in bytes of the data available in the record
     * @exception RecordStoreNotOpenException if the record store is not open.
     * @exception InvalidRecordIDException if the record store is invalid.
     * @exception RecordStoreException if a general record store exception occurs.
     */
    public int getRecordSize (int recordId) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException {
	
	if (openedStore == null) 
	    throw new RecordStoreNotOpenException ();
		
	if (recordId > (openedStore.getNumberOfRecords ()-1)) 
	    throw new InvalidRecordIDException ();

	return (readRecord (recordId)).length;
    }

    
    /**
     * Returns the amount of space, in bytes, that the record store occupies.
     * @return the size of the record store in bytes 
     * @exception RecordStoreNotOpenException if the record store is not open.
     */
    public int getSize () throws RecordStoreNotOpenException {
	if (openedStore == null) 
	    throw new RecordStoreNotOpenException ();
	
	int size = 0;
	int noOfRecs = openedStore.getNumberOfRecords ();
	for (int i = 0; i < noOfRecs; i++) {
	    byte[] buffer = openedStore.getRecord (i);
	    size += buffer.length;
	}
	
	return size;;
    }

    
    /**
     * Returns the amount of additional room (in bytes) available for this record store to grow.
     */
    public int getSizeAvailable () throws RecordStoreNotOpenException {
	return Integer.MAX_VALUE;
    }

    
    /**
     * Each time a record store is modified (record added, modified, deleted), it's version is incremented.
     */
    public int getVersion () throws RecordStoreNotOpenException {
	return 0;
    }

    
    /**
     * Returns an array of the names of record stores owned by the MIDlet suite.
     */
    public static String[] listRecordStores () {
	return null;
    }

    
    /**
     * Open (and possibly create) a record store associated with the given MIDlet suite.
     */
    /*public static RecordStore openRecordStore (String recordStoreName, boolean createIfNecessary) 
      throws RecordStoreException,
      RecordStoreFullException,
      RecordStoreNotFoundException {
      
      return null;
      }*/
    

    /**
     * Removes the specified RecordListener.
     */
    public void removeRecordListener (RecordListener listener) {
    }


    /**
     * Sets the data in the given record to that passed in.
     */
    public void setRecord (int recordId, byte[] newData, int offset, int numBytes) 
	throws RecordStoreNotOpenException,
	       InvalidRecordIDException,
	       RecordStoreException,
	       RecordStoreFullException {
    }
}





