// EventQueue.java
//
// 2000-09-08 MK Added new Licensetext
//      
//#include ..\..\license.txt
//
// kAWT version 0.95
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.awt.event.*;


/** The kAWT event queue. In kAWT, the event queue has no
    entries an delivers all events immediately. */

public class EventQueue {

    Component mouseOwner;
    int mouseOrgX;
    int mouseOrgY;


    /** Posts an event. In kAWT the posted event
	is delivered immediately without buffering. The
	call actually blocks until the event has been
	delivered. */

    public void postEvent (AWTEvent event) {

        Window top = Toolkit.getTopWindow ();
        if (top == null) return;

        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent) event; 

            if (event.id == MouseEvent.MOUSE_PRESSED) {        

                while (true) {
                    Point p = top.getLocationOnScreen ();
                    mouseOwner = top.findComponentAt 
                        (me.getX () - p.x, me.getY () - p.y);
 
                    if (mouseOwner != null) break;
                    if (top.isMenu) {
                        top.setVisible (false);
                        top = Toolkit.getTopWindow ();
                        if (top == null || !top.isMenu) return;
                    }
                    else return;
                }

                Point p = mouseOwner.getLocationOnScreen ();
                mouseOrgX = p.x;
                mouseOrgY = p.y;
            }

            if (mouseOwner == null) return;

            event.setSource (mouseOwner);
            me.translatePoint (-mouseOrgX, -mouseOrgY);
            Toolkit.kawtThread.queueEvent 
                ('m', mouseOwner, me);
        } 
        else if (event instanceof KeyEvent) {

	    event.setSource (top); 
	    Toolkit.kawtThread.queueEvent ('k', top.focus, event);	    
        }

	if (Toolkit.kawtThread.exception != null) 
	    throw Toolkit.kawtThread.exception;

	Toolkit.flushRepaint ();
    }



    public void invokeLater (Runnable runit) {

        synchronized (Toolkit.kawtThread) {
            Toolkit.kawtThread.type = 'r';
            Toolkit.kawtThread.run = runit;
            Toolkit.kawtThread.notify ();
        }
    }
}
