// (C) 2000 Stefan Haustein, Oberhausen (Rhld.), Germany, EU
// Freeware, no warranty, use at own risk (see GPL)


import java.util.*;
import java.io.*;

class BatchBuilder {


    static String resolveEnv (String path) {
	while (true) {
	    int i0=path.indexOf ('%');
	    if (i0 == -1) return path;
	    int i1=path.indexOf ('%', i0+1);
	    if (i1 == -1) return path;
	    String varname = path.substring (i0+1, i1);
	    String resolved = System.getProperty (varname);

	    path = path.substring (0, i0) + resolved + path.substring (i1+1);
	}
    }
	    


    static void buildLauncher (String main, 
			       String fileName) throws IOException {
	
	PrintWriter dest = new PrintWriter (new FileWriter (fileName)); 

	dest.println ("// Wrapper generated by de.kawt.tools.BatchBuilder");
	dest.println ("import javax.microedition.midlet.*;");
	dest.println ("import javax.microedition.lcdui.*;");
	dest.println ("import de.kawt.impl.midp.*;");

	dest.println 
	    ("public class "+main+"Launcher extends MIDletImpl {");

	// dest.println (" de.kawt.midp.KawtCanvas canvas;");

	dest.println (" public void startApp() {");
	dest.println ("  "+main+".main (new String [0]);");
        dest.println (" }");
        dest.println ("}");

	dest.close ();
    }

    static PrintWriter dest;
    static boolean pause = false;

    static void splitCmd (String cmd, String par) { 
	int i0= 0;
	cmd = cmd.trim ();
	par = par.trim ();
	int len = par.length ();

	do {
	    int i1 = i0 + 900 - cmd.length ();
	    if (i1 > len) i1 = len;
	    else {
		i1 = par.indexOf (' ', i1);
		if (i1 == -1) i1 = len;
	    }

	    dest.println (cmd + " "+ par.substring (i0, i1));

	    i0 = i1 + 1;

	    if (pause) dest.println ("pause");
	}
	while (i0 < len);
	
    }
    
    static void println (String s) {
	System.out.println (s);
    }
    

    public static void incorporate (Vector params, 
				    String filename) throws IOException {
	
	Reader reader = new FileReader (filename);

	StringBuffer buf = new StringBuffer ();
	while (true) {
	    int c = reader.read ();
	    if (c <= ' ') {
		if (buf.length () > 0) {
		    String name = buf.toString ();
		    if (name.charAt (0) == '@') 
			incorporate (params, resolveEnv (name.substring (1)));
		    else
			params.add (buf.toString ());
		    buf = new StringBuffer ();
		}
		
		if (c == -1) break;
	    }
	    else buf.append ((char) c);
	}
    }


    public static void main (String [] argv) throws IOException {

	String batch = "generated.bat";
	String bcp = null;
	String dir = ".";
	String verified = "verified";
	String jar = null;
	String pdb = null;
        boolean prc = false;
	String main = null;
	boolean launcher = false;
	String launchFile = null;
	boolean jarx = false;
	String dst = null;
	String target = null;
	boolean net = false;
	boolean zip = false;
	String packages = "";

	if (argv.length == 0) {
	    println ("");
	    println ("de.kawt.tools.BatchBuilder V1.1");
	    println ("");
	    println ("This tool generates a batch file for the different compiling steps of");
	    println ("KVM programs. The KVM tools and the java executables must be in the");
	    println ("the class- / exectution path. If an executable file is generated, the");
	    println ("first class given must be the main class.");
	    println ("");
	    println ("usage: java BatchBuilder [options] [[-C <dir>] classes ... ]");
	    println ("");
	    println (" -bat <filename>  sets detination batch file name; default: generated.bat");
	    println (" -bcp <classpath> sets the boothclasspath; default: .");
	    println (" -C <dir>         changes source base directory; default: .");
	    println (" -d <dir>         sets destination directory for class files");
	    println (" -f <name>        sets filename for executable jar or prc file");
	    println (" -jar <name>      generates jar file");
	    println (" -jarx:           generates an executable jar file");
	    println (" -launcher:       generates a MIDlet wrapper for kAWT programs");
	    println (" -net             set network flag in prc file");
	    println (" -pdb <name>      generates a pdb library");
	    println (" -prc             generates a prc file for the Palm Pilot kvm");
	    println (" -verified: <dir> sets output directory for verified classes; default: verified");
	    println (" -zip             generate zipped prc / pdb file for upload");
	    println (" @filename        imports the given file into the command line");
	    return;
	}


	Vector params = new Vector ();

	for (int i = 0; i < argv.length; i++) {
	    if (argv [i].startsWith ("@")) {
		incorporate (params, argv [i].substring(1)); 
	    }
	    else
		params.add (argv [i]);
	}

	
	// step one: build compile command,  
	// all "ins" must become part of the classpath

	StringBuffer files = new StringBuffer ();
	StringBuffer classes = new StringBuffer ();
	StringBuffer cp = new StringBuffer ();
	
	for (int i = 0; i < params.size (); i++) {
	    String cmd = (String) params.get (i);
	    if (cmd.startsWith ("-")) {
		if (cmd.equals ("-launcher")) 
		    launcher = true;
		else if (cmd.equals ("-prc")) 
		    prc = true;
		else if (cmd.equals ("-zip"))
		    zip = true;
		else if (cmd.equals ("-jarx")) 
		    jarx = true;
		else if (cmd.startsWith ("-net"))
		    net = true;
		else if (cmd.equals ("-pause"))
		    pause = true;
		else {
		    String par = (String) params.get (++i);
		    if (cmd.equals ("-bat"))
			batch = par;
		    else if (cmd.equals ("-d")) 
			dst = par;
		    else if (cmd.equals ("-verified"))
			verified = par;
		    else if (cmd.equals ("-bcp")) 
			bcp = par;
		    else if (cmd.equals ("-pdb")) 
			pdb = par;
		    else if (cmd.equals ("-jar")) 
			jar = par;
		    else if (cmd.equals ("-f")) 
			target = par;
		    else if (cmd.equals ("-in") || cmd.equals ("-cd") || cmd.equals ("-C")) {
			dir = resolveEnv (par);
			if (cp.length () != 0) cp.append (";");
			cp.append (dir);
		    } 
		    else 
			println ("unrecognized switch: "+cmd + " "+ par);
		}
	    }
	    else {
		if (cp.length () == 0) cp.append (".");
		String fileName = 
		    dir + "\\" + cmd.replace ('.', '\\') + ".java ";

		if (classes.length () == 0) {
		    main = cmd;
		    if (launcher) {
			classes.append (main+"Launcher ");
			launchFile = dir+ "\\"+main.replace ('.', '\\')
			    +"Launcher.java ";
			files.append (launchFile);
		    }  
		}


		if (new File (fileName).exists ()) 
		    files.append (fileName);
		else System.out.println 
			 ("Warning: "+fileName+ " does not exist (ignore if class defined in other java file.");

		classes.append (cmd);
		classes.append (" ");
		
		String pkg =  " " + verified + '\\' + cmd.substring 
		    (0, cmd.lastIndexOf ('.') + 1).replace ('.', '\\') + "*.class";

		if (packages.indexOf (pkg) == -1)
		    packages = packages + pkg;
	    }
	}

	dest = new PrintWriter (new FileWriter (batch));

	if (dst != null) 
	    dest.println ("mkdir "+dst);

	
	splitCmd 
	    ("javac -O -g:none " + (bcp != null ? "-bootclasspath "+bcp : "")
	     +" -classpath "+cp 
	     + (dst == null ? "" : " -d "+dst)  
	     + " " , files.toString ());

	if (bcp != null) 
	    splitCmd 
		("preverify -classpath "
		 +bcp+";"+(dst==null ? cp.toString () : dst)
	     +" -d "+verified, classes.toString ());
	else
	    verified = dst;

	if (target == null) 
	    target = main.substring (main.lastIndexOf ('.')+1); 

	if (prc) { 
	    if (target.endsWith (".prc")) 
		target = target.substring (0, target.length () - 4);

	   // if (net) target = target + "Net";

	    dest.println 
		("java palm.database.MakePalmApp"
		 + (net ? " -networking " : "") 
		 +" -bootclasspath "+bcp
		 +" -classpath "+verified+" -name " + target + " -o "+target+".prc " +classes); 
	    
	    if (zip) {
		int cut = target.lastIndexOf ('\\');
		if (cut == -1) {
		    target = ".\\"+target;
		    cut = 1;
		}
		dest.println ("jar cfM "+target+"_prc.zip -C "+ target.substring (0, cut)+" "+ target.substring (cut+1)+".prc");
	    }
	}
	if (pdb != null) {
	    if (pdb.endsWith (".pdb"))
		pdb = pdb.substring (0, pdb.length () - 4);

	    dest.println 
		("java palm.database.MakePalmDB -creator kJav -classpath "
		 +verified + " -o "+pdb+ ".pdb " +packages); 


	    if (zip) {
		int cut = pdb.lastIndexOf ('\\');
		if (cut == -1) {
		    pdb = ".\\"+pdb;
		    cut = 1;
		}
		dest.println ("jar cfM "+pdb+"_pdb.zip -C "+ pdb.substring (0, cut)+" "+ pdb.substring (cut+1)+".pdb");
	    }
	}

	if (jar != null || jarx) {
	    
	    if (jarx) {
		dest.println ("mkdir "+verified+"\\META-INF");
		dest.println ("echo Main-Class: "+main+"> "
			      +verified+"\\META-INF\\MANIFEST.MF");

		jar = target;
	    }
	    if (jar.indexOf ('.') == -1) jar = jar+".zip";
	    dest.println ("jar cfM "+jar+ " -C "+ verified+" .");
	}
	dest.close ();

	if (launcher) {
	    buildLauncher (main, launchFile);
	}
    }
}
