package de.kawt.impl.j2se;

import java.applet.*;
import java.awt.*; 
import java.awt.event.*; 
import de.kawt.KAWTlet;
import de.kawt.impl.WrapperInterface;


public class KawtWrapper extends Applet 
    implements ActionListener, WrapperInterface {

    KAWTlet kawtlet;
    Button button = new Button ("...");
    boolean running = false;

    public void init () {

	setLayout (new BorderLayout ());
	add ("Center", button);
	button.addActionListener (this);

	KAWTlet.currentWrapper = this;

	try {
	    kawtlet = (KAWTlet) Class.forName (getParameter ("KAWTlet")).newInstance ();
	}
	catch (Exception e) {
	    throw new RuntimeException (e.toString ());
	}

	updateButton (); 
    }

    public void actionPerformed (ActionEvent ev) {
	if (running) {
	    kawtlet.destroyApp (true);
	    running = false;
	}
	else {
	    kawtlet.startApp ();
	    running = true;
	}
	updateButton ();
    }
	

    public void notifyDestroyed () {
	running = false;
	updateButton ();
    }
	

    public void stop () {
	kawtlet.destroyApp (true);
	running = false;
	updateButton ();
    }
       
    void updateButton () {
	button.setLabel (running ? "Stop" : "Start");
    }
}

