// kAWT
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS

package de.kawt.impl.midp;

import java.io.*;
import java.awt.Toolkit;
import java.awt.event.*;
import javax.microedition.lcdui.*;


public class CanvasImpl
    extends Canvas
    implements CommandListener {
    
    static Image offScreen;
    static Graphics graphics;
    //    static String cmdName;
    //    static Command command;
    

    Command cancelCommand = new javax.microedition.lcdui.Command
	("Esc", javax.microedition.lcdui.Command.SCREEN, 0);
    
    Command menuCommand = new javax.microedition.lcdui.Command
	("Menu", javax.microedition.lcdui.Command.SCREEN, 0);

    public CanvasImpl () {
         
 	offScreen = Image.createImage
 	    (getWidth (), getHeight ());
        
 	graphics = offScreen.getGraphics ();
        
	addCommand (cancelCommand);
        addCommand (menuCommand);

        setCommandListener (this);
    }
    

    /** shouldn't be a real problem to add mechanism for 
	char input.... */
	

    public void keyPressed (int keyChar) {
 
	int gameAction = getGameAction (keyChar); 
	int keyCode = KeyEvent.VK_UNDEFINED;

	switch (gameAction) { 
	case UP: keyCode = KeyEvent.VK_UP; break;
	case DOWN: keyCode = KeyEvent.VK_DOWN; break;
	case LEFT: keyCode = KeyEvent.VK_LEFT; break;
	case RIGHT: keyCode = KeyEvent.VK_RIGHT; break;
	case FIRE: keyCode = KeyEvent.VK_ACCEPT; break;
	case GAME_A: keyCode = KeyEvent.VK_CANCEL; break;
	}
	    
	if (keyCode != KeyEvent.VK_UNDEFINED)
	    Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
		(new KeyEvent (null,
			       KeyEvent.KEY_PRESSED, 0, 0,
			       keyCode, KeyEvent.CHAR_UNDEFINED));
	else
            Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
		(new KeyEvent (null,
			       KeyEvent.KEY_TYPED, 0, 0,
			       KeyEvent.VK_UNDEFINED, (char) keyChar));
    }
    
 

    public void pointerPressed (int x, int y) {
         
        Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
            (new MouseEvent (null,
                             MouseEvent.MOUSE_PRESSED, 0, 0,
                             x, y, 0, false));
    }
    
 
    public void pointerReleased (int x, int y) {
        

	Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
	    (new MouseEvent (null,
			     MouseEvent.MOUSE_RELEASED, 0, 0, x, y,
			     0, false));
	
	
	Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
	    (new MouseEvent (null,
			     MouseEvent.MOUSE_CLICKED, 0, 0, x, y,
			     0, false));
	
    }

 

    public void pointerDragged (int x, int y) {
        
	Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
	    (new MouseEvent (null, MouseEvent.MOUSE_DRAGGED, 0, 0,
			     x, y, 0, false));
    }


    public void commandAction (javax.microedition.lcdui.Command c,
 			       javax.microedition.lcdui.Displayable s) {

         Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
             (new KeyEvent 
		 (null,
		  KeyEvent.KEY_PRESSED, 0, 0,
		  c == menuCommand ? KeyEvent.VK_PROPS : KeyEvent.VK_CANCEL, 
		  KeyEvent.CHAR_UNDEFINED));
         
     }
 
 
     /** public for kawt-internal purposes. Do not touch! */

     public void paint (javax.microedition.lcdui.Graphics g) {
         
          g.drawImage (offScreen, 0, 0,
 		     javax.microedition.lcdui.Graphics.TOP
 		     | javax.microedition.lcdui.Graphics.LEFT);

        GraphicsImpl.dirty = false;
     }

}




