// Graphics.java
//
// 2000-10-14 SH Improved Color management, white lines, rects
// 2000-10-06 SH dividet into abstract graphics and implementation
// 2000-09-28 SH Synchronization removed since kAWT is not thread
//               safe anyway. Removed complex clipping suppport,
//               too.
// 2000-09-08 MK Added new Licensetext
// 2000-08-25 SH DrawOval ifdef for MIDP added, some MIDP offset fixes
// 2000-08-06 SH Changes for MIDP compatibility 
// 2000-06-25 Draw*Rect changes for AWT compatibility 
//            (1 pixel larger than one would expect)
// 2000-05-26 Color support added
// 2000-05-20 SH hitClip added
// 2000-05-01 SH create from graphics bug fixed
// 2000-04-09 SH Preparation for improved repaint: multiple clip rects 
//
//#include ..\..\license.txt
//
// kAWT version 0.95
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package de.kawt.impl.rim;

import java.awt.*;
import java.util.Vector;
import java.awt.image.ImageObserver;


public class GraphicsImpl extends Graphics {

    static GraphicsImpl current;
    static net.rim.device.api.system.Graphics rimGraphics;
    static boolean clipActive = false;

    int orgX;
    int orgY;
    Color color = Color.black;
    FontMetricsImpl fontMetrics = FontMetricsImpl.defaultFontMetrics; 
    int clipX;
    int clipY;
    int clipW;
    int clipH;
    int rgb = 0;
    boolean white;

    public GraphicsImpl () {
        clipW = ToolkitImpl.app.screen.getWidth (); 
        clipH = ToolkitImpl.app.screen.getHeight ();
    }


    public Graphics create () {
        GraphicsImpl g = new GraphicsImpl ();

        g.orgX = orgX;
        g.orgY = orgY;

        g.clipX = clipX;
        g.clipY = clipY;
        g.clipW = clipW;
        g.clipH = clipH;

        g.color = color;
        g.rgb = rgb;
	g.white = white;

        return g;
    }
    
    
    public boolean checkContext () {

        if (rimGraphics == null) {
            current = null;
            return false;
        }

        if (current != this) {
            if (clipActive) rimGraphics.popTranslation ();
            
            rimGraphics.pushClip (clipX, clipY, clipW, clipH, 0, 0);
            clipActive = true;
            
            rimGraphics.setColor (rgb);
            rimGraphics.setFont (fontMetrics.rimFont);
        }

        return true;
    }
        

    public void clipRect (int x, int y, int w, int h) {
        current = null; // force setDrawRegion

        x += orgX;
        y += orgY;

        if (x > clipX) {
            clipW -= x - clipX;
            clipX = x;
        }

        if (y > clipY) {
            clipH -= y - clipY;
            clipY = y;
        }

        if (x + w < clipX + clipW)
            clipW = x + w - clipX;

        if (y + h < clipY + clipH)
            clipH = y + h - clipY;
    }

    
    public Color getColor () {
        return color;
    }

    public void setClip (int x, int y, int w, int h) {
        current = null;
        clipX = x + orgX;
        clipY = y + orgY;
        clipW = w;
        clipH = h;
    }
    
    
    public void clearRect (int x, int y, int w, int h) {
        if (checkContext ())
            rimGraphics.clear (x, y, w, h);
    }
    
    
    public boolean drawImage (Image image, int x, int y, 
                           ImageObserver observer) {
        
        checkContext ();

        // XXX

        return true;
    }


    
    public void drawLine (int x1, int y1, int x2, int y2) {

        if (checkContext ()) {
	    if (white) {
		if (x1 == x2) 
		    rimGraphics.clear (x1+orgX, y1+orgY, 1, y2-y1);
		else if (y1 == y2)
		    rimGraphics.clear (x1+orgX, y1+orgY, x2-x1, 1);
	    }
	    else
		rimGraphics.drawLine (x1+orgX, y1+orgY, x2+orgX, y2+orgY);
	}
    }


    public void drawPolyline (int[] xPoints, int[] yPoints, 
                              int nPoints) {

        if (checkContext ()) {
          for (int i = 0; i < nPoints - 1; i++) {
            rimGraphics.drawLine
                (xPoints[i] + orgX, yPoints[i] + orgY,
                 xPoints[i+1] + orgX, yPoints[i+1] + orgY);
          }
    }
    }
    

    public void drawRoundRect (int x, int y, int width, int height, 
                                 int arcWidth, int arcHeight) {

        if (checkContext ()) 
           rimGraphics.drawRoundRect
            (orgX + x, orgY + y,
             width+1, height+1,
             1, 1);
    }


    public void drawString (String text, int x, int y) {

        if (checkContext ()) {
            rimGraphics.drawText 
                (text, x + orgX, y + orgY-1, 
                 net.rim.device.api.system.Graphics.LEFT
                 |net.rim.device.api.system.Graphics.BASELINE); 
                 
            if (white)
              rimGraphics.invert (x+orgX, y+orgY-fontMetrics.getAscent (), 
                                  fontMetrics.stringWidth (text), 
                                  fontMetrics.getHeight ());
         }

    }


   

    public void drawOval (int x, int y, int w, int h) {
        
        if (checkContext ())
            rimGraphics.drawArc (x+orgX, y+orgY, w+1, h+1, 0, 360);
     }


    public void drawRect (int x,  int y, int width, int height) {

	x += orgX;
	y += orgY;

        if (checkContext ()) {
	    if (white){
		rimGraphics.clear (x, y, width, 1);
		rimGraphics.clear (x, y, 1, height);
		rimGraphics.clear (x, y+height, width, 1);
		rimGraphics.clear (x+width, y, 1, height);
	    }
	    else rimGraphics.drawRect (x, y, width+1, height+1);    
	}
    }

    
    public void fillRect (int x, int y, int width, int height) {
        if (checkContext ()) {
            rimGraphics.clear (x+orgX, y+orgY, width, height);
            if (!white)
              rimGraphics.invert (x+orgX, y+orgY, width, height);
         }
    }
    
  
    public void fillRoundRect (int x, int y, 
                               int width, int height, 
                               int arcWidth, int arcHeight) {
       
        fillRect (x, y, width, height);
    }
    
    
    public Font getFont () {
        return fontMetrics.getFont ();
    }
    
    
    public boolean hitClip (int x, int y, int w, int h) {
      
        x += orgX;
        y += orgY;
        
        return ((clipX <= x + w) && (clipX + clipW >= x) 
                && (clipY <= y + h) && (clipY + clipH >= y));
    }
    

    public Rectangle getClipBounds () {
        return new Rectangle (clipX - orgX, clipY - orgY, clipW, clipH);
    }

    public Rectangle getClipBounds (Rectangle r) {
        r.x = clipX - orgX;
	r.y = clipY - orgY;
	r.width = clipW;
	r.height = clipH;
	return r;
    }



    public FontMetrics getFontMetrics () {
        return fontMetrics;
    } 


    public FontMetrics getFontMetrics (Font font) {
        return new FontMetricsImpl (font);
    } 


    public void setColor (Color c) {
        color = c;
        rgb = c.getRGB ();
	white = ((rgb >> 16) + ((rgb >> 8) & 255) + (rgb & 255) > 128*3);
        if (checkContext ())
           rimGraphics.setColor (rgb);
    }
    

    public void setFont (Font font) {
        fontMetrics = new FontMetricsImpl (font);
        if (checkContext ()) 
           rimGraphics.setFont (fontMetrics.rimFont);
    }
    

    public void setPaintMode () {
    }


    public void setXORMode (Color c2) {
    }
        

    public void translate (int x, int y) {
        orgX += x;
        orgY += y;
    }
}






