/*
 * TabbedPane.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package de.trantor.kawt;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;


class TabControl extends Canvas implements MouseListener {

  int selected;
  boolean mono = 
  Toolkit.getDefaultToolkit ().getColorModel ().getPixelSize () == 1; 

  Vector titles = new Vector ();
  TabbedPane tabbedPane;

  TabControl (TabbedPane tabPane) {
    tabbedPane = tabPane;
    addMouseListener (this);
    setBackground (SystemColor.control);
  }


  public void add (String title) {
	titles.addElement (title);
	repaint ();
  }

    
  public Dimension getMinimumSize () {
    FontMetrics m = getFontMetrics (getFont ());
	return new Dimension (160, m.getHeight () + (mono ? 5 : 8));
  }
    

  public Dimension getPreferredSize () {
	return getMinimumSize ();
  }


  public void drawTab (Graphics g, int x, int y, int w, int h, int dt, String text) {
    if (mono) {
	  g.setColor (Color.black);
	  g.drawLine (x, y+h-1, x, y+2);
	  g.drawLine (x, y+2, x+2, y);
	  g.drawLine (x+2, y, x+w-2, y);      
	  g.drawLine (x+w-2, y, x+w, y+2);  // one pixel wider than spec.
	  g.drawLine (x+w, y+2, x+w, y+h-1);
	  g.drawString (text, x + 5 + dt, y + h - 5);
	}
	else {
	  g.setColor (Color.white);
	  g.drawLine (x,   y+h-1, x,   y+2);     // ganz links
	  g.drawLine (x+1, y+h-1, x+1, y+1);
	    
	  g.drawLine (x+3, y,   x+w-3, y);       // ganz oben
	  g.drawLine (x+2, y+1, x+w-2, y+1);
	    
	  g.setColor (Color.black);           // ganz rechts
	  g.drawLine (x+w-1, y+2, x+w-1, y+h-1); 
	    
	  g.setColor (Color.gray);
	  g.drawLine (x+w-2, y+1, x+w-2, y+h-2); 
	    
	  g.setColor (SystemColor.controlText);
	  g.drawString (text, x + 5 + dt, y + h - 8);
	}
  }
    
  public void paint(Graphics g) {

	int overlap = mono ? 0 : 2;
	int offset = overlap;
	int selectedOffset = offset;
	int selectedWidth = 0;

	FontMetrics metrics = g.getFontMetrics();

	int h = getHeight ();

	for (int i = 0; i < titles.size(); i++) {
	  String title = (String) titles.elementAt (i);
	  int w = metrics.stringWidth (title) + 10;           
	    
	  if (i == selected) {
		selectedOffset = offset;
		selectedWidth = w;
	  }
	  else 
	  	drawTab (g, offset, 2, w, h, 0, title);
	  offset += w;
	}

	drawTab (g, selectedOffset-overlap, 0, 
		     selectedWidth+overlap+overlap, h, overlap, 
		     (String) titles.elementAt (selected));

	if (!mono) {
	  g.setColor (Color.white);
	  g.drawLine (0, h-2, selectedOffset-1, h-2);
	    
	  g.drawLine (selectedOffset + selectedWidth+2, h-2, 
			getWidth (), h-2);
	}

	g.drawLine (0, h-1, selectedOffset-1, h-1);
	g.drawLine (selectedOffset + selectedWidth+1, h-1, 
		    getWidth (), h-1);

  }
	

  public void mouseEntered (MouseEvent me) {};
  public void mouseExited (MouseEvent me) {};
  public void mousePressed (MouseEvent me) {};
  public void mouseDragged (MouseEvent me) {};
  public void mouseClicked (MouseEvent me) {};
    
  public void mouseReleased (MouseEvent me) {
  	
	if (me.getID() == me.MOUSE_RELEASED) {
	    
	  int xoffset = 0;
	  int mx = me.getX ();
	   
	  Graphics g = getGraphics();
		if (g == null) return;
	
		FontMetrics fm = g.getFontMetrics();
		
		for (int i = 0; i < titles.size(); i++) {
	   
	      int nextOffset = xoffset + 10 + 
	  	  fm.stringWidth ((String) titles.elementAt(i));
		    
		  if (mx >= xoffset && mx < nextOffset) { 
			tabbedPane.setSelectedIndex (i);
			break;
		  }
		  xoffset = nextOffset;
		}
	  }
    }
  }


public class TabbedPane extends Panel {

    CardLayout cardLayout;
    Panel mainPanel;
    TabControl tabControl;
     
    public TabbedPane() {
	super (new BorderLayout ());

	cardLayout = new CardLayout();
	mainPanel = new Panel (cardLayout);
	tabControl = new TabControl (this);
	
	add ("North", tabControl);
	add ("Center", mainPanel);
    }
  

    
    public void addTab (String title, Component component) {
	mainPanel.add (title, component);
	tabControl.add (title);
    }


 
    public void setSelectedIndex (int index) {

	if (index >= 
	    0 && index < tabControl.titles.size() 
	    && index != tabControl.selected) {
	    
	    tabControl.selected = index;
	    cardLayout.show 
		(mainPanel, (String) tabControl.titles.elementAt 
		 (tabControl.selected));
	    
	    tabControl.repaint ();
	}
  }
}