/*
 * CheckBox.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import java.util.*;
import java.awt.event.*;


public class Checkbox extends Component {  
	
  private ActionListener actionListener = null;
    
  int minWidth;
  static int minHeight = 12;
    
  String label;
  boolean state = false;
  CheckboxGroup group;
  ItemListener itemListener;
 
  public Checkbox (String s) {
  	this (s, null, false);
  }

  public Checkbox (String s, boolean checked) {
	this (s, null, checked);
  }

  public Checkbox (String s, boolean state, CheckboxGroup group) {
	this (s, group, state);
  }
    
  public Checkbox (String s, CheckboxGroup group, boolean state) {
	setLabel (s);
	setCheckboxGroup (group);		
	setState (state);
  }

    public void addItemListener (ItemListener il) {
	if (itemListener != null) 
	    throw new TooManyListenersException ();
	
	itemListener = il;
    }

    public Dimension getMinimumSize () {
	return new Dimension (minWidth, minHeight);
    }

  public boolean getState () {
	return state;
  }

  public void paint(Graphics g) {
	int middle = height / 2;
	if (group == null) {
	    g.drawRect (0, middle-2, 8, 8);
	    g.drawString (label, 12, middle+6); 
	}
	else {
	    g.drawRoundRect (0, middle-4, 10, 10, 4, 4);
	    g.drawString (label, 12, middle+6); 
	}
	
	if (state && group != null) 
	    g.fillRect (3, middle-1, 4, 4);
	else if (state && group == null) {
	    g.setColor (Color.white);
	    g.drawLine (7, middle-2, 6, middle-2);
	    g.drawLine (7, middle-2, 7, middle+1);
	    g.setColor (Color.black);
	    g.drawLine (4, middle+3, 9, middle-2);
	    g.drawLine (4, middle+2, 9, middle-3);
	    g.drawLine (3, middle+2, 8, middle-3);
	    g.fillRect (2, middle, 2, 2);
	}
  }

  public void processItemEvent (ItemEvent e) {
	if (itemListener != null) 
      itemListener.itemStateChanged (e);
  }
    
  public void processMouseEvent (MouseEvent e) {
	if (e.getID () != e.MOUSE_PRESSED) return;
	Graphics g = getGraphics ();
	if (group == null) setState (!state);
	else setState (true);
  }
    
  public void setCheckboxGroup (CheckboxGroup newGroup) {
  	if (group != null) 
	    group.checkboxes.removeElement (this);
	
  	group = newGroup;
	if (group != null)
	    group.checkboxes.addElement (this);
  }
    
  public void setState (boolean sel) {
    if (sel != state) {
    if (group == null) {
	  state = !state;
	  repaint ();
	      
	  processItemEvent 
	    (new ItemEvent 
	    (this, ItemEvent.ITEM_SELECTED, this, 
	    sel ? ItemEvent.SELECTED : ItemEvent.DESELECTED)); 
	}
	  else group.setSelectedCheckbox (this);
    }
  }
    
  public void setLabel (String s) {
	this.label = s;
	minWidth = com.sun.kjava.Graphics.getWidth(s)+12;
  }
}

