/*
 * Choice.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

import java.awt.event.*;

public class Choice extends Component {

  List list = new List ();
  Window window;
  ItemListener itemListener;

  public Choice () {
	list = new List (this);
	list.selected = 0;
  }

  public void add (String item) {
	list.add (item);
  }

  public void addItem (String item) {
	add (item);
  }

  public void addItemListener (ItemListener l) {
	if (itemListener != null) 
	    throw new TooManyListenersException ();
	
	itemListener = l;
  }
    
    public String getItem (int index) {
	return (String) list.elements.elementAt (index);
    }
    
    public int getItemCount () {
	return list.elements.size ();
    }

    public int getSelectedIndex () {
	return list.selected;
    }

    public String getSelectedItem () {
	return (String) list.elements.elementAt (list.selected);
    }
    

    public Dimension getMinimumSize () {
	Dimension ms = list.getMinimumSize ();
	ms.height = 11;
	return ms;
  }

  /*
  public void insert (String item, int index) {
	list.elements.add (index, item);
  }
  */

    public void processMouseEvent (MouseEvent ev) {
	if (ev.getID () != ev.MOUSE_CLICKED) return;
	
	if (window == null) { 
	    window = new Window (_getWindow ().owner);
	    
	    window.isMenu = true;
	    window.add ("Center", list);
	    window.pack ();
	}

	Point p = getLocationOnScreen ();

	Dimension scr = Toolkit.getDefaultToolkit ().getScreenSize ();
	
	window.x =  (short) p.x;
	window.y =  (short) (p.y + (height - window.height) / 2);

	if (window.x + window.width > scr.width) 
	    window.x = (short) (scr.width - window.width);
	if (window.y + window.height > scr.height) 
	    window.y =  (short) (scr.height - window.height);
	if (window.y < 0) window.y = 0;
	if (window.x < 0) window.x = 0;

	window.show ();	
  }

  public void paint (Graphics g) {

	String sel = "" + list.getSelectedItem ();
	g.drawString (sel, 0, height / 2 + 5);
	int tw = g.getFontMetrics (g.getFont ()).stringWidth (sel);
	g.drawImage (Scrollbar.imgDown, tw + 3, height/2-3, this);
  }

  public void remove (String item) {
	list.elements.removeElement (item);
  }

  public void remove (int index) {
	list.elements.removeElementAt (index);
  }

  public void select (int index) {
	if (index != list.selected) {
      int old = list.selected;
	  list.selected = index;
	  repaint ();
	  /*
	  if (itemListener != null) 
		itemListener.itemStateChanged (new ItemEvent (
	  */
	} 
  }
    
  public void select (String item) {
	select (list.elements.indexOf (item));
  }
}
