/*
 * Component.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import java.util.Vector;
import java.awt.event.*;


/** Important Limitations:
 *   <ul>
 *   <li>Only one listener of each type is allowed</li>
 *   <li>Many methods are still missing</li>
 *   <ul>
 *   Many events are not passed through the processXXXEvent-Methods
 *   but delivered directly to the registered listener. 
 *
 */

public abstract class Component {

    int x;
    int y;
    int width;
    int height;

    boolean enabled = true;
    boolean visible = true;
    boolean hasFocus = false;
    boolean valid = false;
    
    Container parent;
    
    MouseListener mouseListener;
    KeyListener keyListener;
    
    //  Font font;
    //Color background = Color.white;
    
    public Component () {}
  
    public void addMouseListener (MouseListener l) {
	if (mouseListener != null)
	    throw new TooManyListenersException ();
	
	mouseListener =  l;
    }

    public void addKeyListener (KeyListener l) {
	if (keyListener != null)
	    throw new TooManyListenersException (); 
	
	keyListener =  l;
    }
    
    
    public Component findComponentAt (int px, int py) {
	return (visible && contains (px, py)) ? this : null; 
    }


    /** returns null if not visible / on screen */
    
    /*
      public Point getLocationOnScreen () {
      
    if (parent == null) return null; // what abt visible?!
    
    Point ret = parent.getLocationOnScreen ();

    if (ret != null) {
    ret.x += x;
	  ret.y += y;
	  }
	  return ret;
	  }
  */
    
  public Point getLocationOnScreen () {
	
	if (parent == null || !visible)  
	    return null; 

	// avoid recursion in order to save stack space...

	Point ret;
	{
	  Component current = this;
	
	    int sx = 0;
	    int sy = 0;
	
	    do {
		if (!current.visible) return null;
		sx += current.x;
		sy += current.y;
		current = current.parent;
	    } 
	    while (current.parent != null);
	    
	    ret = current.getLocationOnScreen ();

	    if (ret != null) {
		ret.x += sx;
		ret.y += sy;
	    }
	}
	return ret;
  }


    public Font getFont () {
	return Font.defaultFont;
    }

	   
    public FontMetrics getFontMetrics (Font font) {
	return new FontMetrics (font);
    }

	
    public Graphics getGraphics () {
	
	Point loc = getLocationOnScreen ();
	if (loc == null) return null;
	
	Graphics g = new Graphics ();
	g.translate (loc.x, loc.y);
	g.clipRect (0, 0, width, height);
	
	return g;
    }
	
    
    public int getX() {
	return x;
    }

    
    public int getY() {
	return y;
    }

    
    public int getWidth() {
	return width;
    }

    
    public int getHeight() {
	return height;
    }
    
    
    public Dimension getPreferredSize () {
	return getMinimumSize ();
    }
    
    
    public Dimension getMinimumSize () {
	return new Dimension (8, 8);
    }


    public boolean contains (int x, int y) {
	return x >= 0 && x <= width && y >= 0 && y <= height;
    }
  
    /*
    void doLayout () {  
    }
    */

    public void invalidate () {
	valid = false;
	if (parent != null) parent.invalidate ();
    }
    

    public boolean isEnabled () {
	return enabled;
    }
    
    
    public void setBounds (int x, int y, int width, int height) {
      this.x = x;
      this.y = y;
      this.width = width;
      this.height =  height;
      //repaint ();
    }
    
    
    public void setEnabled (boolean b) {
	if (enabled != b) {
	    enabled = b;
	    repaint ();
	}
    }

    
    public void setLocation (int x, int y) {
	this.x =  x;
	this.y =  y;
	//	repaint ();
    }
    

    public void setSize (int w, int h) {
	width =  w;
	height =  h;
    }
    

    public void setSize (Dimension d) {
	width =   d.width;
	height =  d.height;
    }
    

    public void paint (Graphics g){
    }

    
    public void paintAll (Graphics g) {
	if (visible && g != null) paint (g);
    }
    

    public void proxyRequestFocus (Component c) {
	if (parent != null) parent.proxyRequestFocus (c);
    }


    public void requestFocus () {
	if (parent != null) parent.proxyRequestFocus (this); 
    }


    public void update (Graphics g) {
	g.clearRect (0, 0, width, height);
	paintAll (g);
    }
    
    public void repaint (int x, int y, int w, int h) {
	Graphics g = getGraphics ();
	if (g == null) return;
      
	g.clipRect (x, y, w, h);
	update (g);
    }

    public void repaint () {
	Graphics g = getGraphics ();
	if (g == null) return;
	
	//Caret.caret.setVisible (false);
	
	update (g);
	
	//Caret.caret.setVisible (true);
    }

    /** Does not work because of the type cast Problem!
     *  All event sources call the specialized method 
     *  (e.g. processMouseEvent) directly
     */
    

    public void processMouseEvent (MouseEvent e) {
	if (mouseListener == null) return;
	
	switch (e.getID ()) {
	case MouseEvent.MOUSE_PRESSED: 
	    mouseListener.mousePressed (e); break;
	    
	case MouseEvent.MOUSE_RELEASED: 
	    mouseListener.mouseReleased (e); break;
	    
	case MouseEvent.MOUSE_CLICKED: 
	    mouseListener.mouseClicked (e); break;
	}
    }


    public void processKeyEvent (KeyEvent e) {
	if (keyListener == null) return;
	
	switch (e.getID ()) {
	case KeyEvent.KEY_PRESSED: keyListener.keyPressed (e); break;
	case KeyEvent.KEY_RELEASED: keyListener.keyReleased (e); break;
	case KeyEvent.KEY_TYPED: keyListener.keyTyped (e); break;
	}
    }


    /** the Backgroundcolor is currently ignored completely (always white)
     */

  public void setBackground (Color color) {
	//	background = color;
  }

  public void setVisible (boolean v) {
	if (v != visible) {
	    visible = v;
	    invalidate ();
	    repaint ();
	}
  }

  public void validate () {
	valid = true;
  }

    Window _getWindow () {
	Component w = this;
	while (w.parent != null) w=w.parent;

	return (Window) w;
    }
}
