/*
 * GridLayout.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import java.util.Vector;

public class GridLayout implements LayoutManager {
    
  int rows;
  int cols;
  int hGap;
  int vGap;

  public void addLayoutComponent (String where, Component component) {}

  public GridLayout (int rows, int cols) {
	this (rows, cols, 1, 1);
  }


  public GridLayout (int rows, int cols, int hGap, int vGap) {
	this.rows = rows;
	this.cols = cols;
	this.hGap = hGap;
	this.vGap = vGap;

	if (rows == 0 && cols == 0) 
	    throw new RuntimeException 
		("rows and cols must not both be 0");
  }
    
  public Dimension minimumLayoutSize (Container parent) {
	int cw = 0;
	int ch = 0;
	int count = parent.children.size ();

	for (int i = 0; i < count; i++) {

	    Component c = (Component) parent.children.elementAt (i);
	    Dimension d = c.getMinimumSize ();

	    if (d.width > cw) cw = d.width;
	    if (d.height > ch) ch = d.height;
	}

	int rowCount = (rows == 0) ? ((count + cols - 1) / cols) : rows;
	int colCount = (rowCount * cols < count) 
	    ? ((count + rows - 1) / rows) : cols;


	return new Dimension 
	    (colCount * (cw + vGap) - vGap 
	     + parent.insets.left + parent.insets.right, 
	     rowCount * (ch + hGap) - hGap 
	     + parent.insets.top + parent.insets.bottom); 
  }


  public void layoutContainer (Container parent) {
	
	int x0 = parent.insets.left;
	int y0 = parent.insets.top;

	int w0 = parent.width - x0 - parent.insets.right;
	int h0 = parent.height - y0 - parent.insets.bottom;

	int count = parent.children.size ();

	int rowCount = (rows == 0) ? ((count + cols - 1) / cols) : rows;
	int colCount = (rowCount * cols < count) 
	    ? ((count + rows - 1) / rows) : cols;

	int cellW = w0 / colCount;
	int cellH = h0 / rowCount;

	int index = 0;
	int currentY = y0;

	for (int indexY = 0; indexY < rowCount; indexY++) {

	    int currentX = x0;
	    
	    for (int indexX = 0; indexX < colCount; indexX++) {
		
		if (index >= count) return;
		
		Component c = (Component) parent.children.elementAt (index++);
		
		c.x =  (short) currentX;
		c.y =  (short) currentY;
		c.width =  (short) (cellW - 1);
		c.height =  (short) ( cellH - 1);
		
		c.valid = false;
	      
		currentX += cellW;
	    }
	    currentY += cellH;
	}
  }
} 































