/*
 * List.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

import java.awt.event.*;
import java.util.Vector;

/** the List is currently only used as helper class for the choice since
 *  scrolling is not yet implemented
 */

public class List extends Component {

  Vector elements = new Vector ();

  int lineHeight = 12;
  int selected = -1;
  Choice choice;
  Scrollbar scrollbar;

  ItemListener itemListener;

  public List () {
  }

  List (Choice choice) {
	this.choice = choice;
  }

  public void add (String item) {
	elements.addElement (item);
  }

  public void addItemListener (ItemListener il) {
	if (itemListener != null) 
	    throw new TooManyListenersException ();

	itemListener = il;
  }


  public Dimension getMinimumSize () {
	int border = (choice == null) ? 2 : 4;
	return new Dimension 
	    (50 + border + 2, elements.size () * lineHeight + border);
  }

    
  public String getSelectedItem () {
	if (selected < 0 || selected >= elements.size ()) return null;
	return (String) elements.elementAt (selected);
  }


  public void paint (Graphics g) {

	if (choice != null) {
	    g.drawLine (2, 1, width-3, 1);
	    g.drawLine (2, height-2, width-2, height-2);
	    g.drawLine (3, height-1, width-3, height-1);

	    g.drawLine (1, 2, 1, height-3);
	    g.drawLine (width-2, 2, width-2, height-2);
	    g.drawLine (width-1, 3, width-1, height-3);
	}
	else 
	    g.drawRect (0,0,width,height);

	int border = (choice == null) ? 1 : 2;


	// care abt scrollbar pos and size here only!
	int visible = (height - 2 * border) / lineHeight;

	if (visible < elements.size ()) {
 	    if (scrollbar == null) {
		scrollbar = new Scrollbar (); 
		scrollbar.internalOwner = this;
		scrollbar.setSize (scrollbar.getMinimumSize ());
	    }

	    scrollbar.maxValue = elements.size () - visible;
	    scrollbar.currVisible = visible;
	    scrollbar.blockIncrement = visible;
	    
	    scrollbar.height = (short) ( height - border-border);

	    scrollbar.paint 
		(g.create (width - scrollbar.width-border, border, 
			   scrollbar.width, scrollbar.height));

	    g = g.create (border, border, 
			  width - scrollbar.width-border-border, 
			  height - border - border);
	    // create new graphics with new clipping here
	}
	else {
	    g = g.create (border, border, width - border*2, height - border*2);
	    scrollbar = null;
	}

	int i = (scrollbar == null) ? 0 : scrollbar.currValue;
	int ty = 0;
	
	while (i < elements.size () && ty < height) {
	    // XXX change in Graphics (baseline!)
	    
	    g.drawString (""+elements.elementAt (i), border+1, 
			  ty+lineHeight-1); 

	    if (i == selected) {
		g.setXORMode (Color.black);
		g.fillRect (1, ty, width-border-border, lineHeight);
		g.setPaintMode ();
	    }

	    i++;
	    ty += lineHeight;
	}
  }


  public void processMouseEvent (MouseEvent me) {
	if (scrollbar != null 
	    && me.getX () > width - scrollbar.width - 2) {
	    me.translatePoint (- (width - scrollbar.width -2), -1);
	    scrollbar.processMouseEvent (me);
	    return;
	}

	if (me.getID () != me.MOUSE_CLICKED) return;

	int sel = ((scrollbar == null) ? 0 : scrollbar.currValue) 
	    + me.getY () / lineHeight;
	
	if (sel < 0) sel = 0;
	if (sel >= elements.size ()) sel = elements.size () -1;

	if (choice != null) {
	    selected = sel;
	    choice.window.setVisible (false);
	}
	else if (sel != selected) {
	    selected = sel;
	    repaint ();
	}
  }
}
