/*
 * TextComponent.java Version 0.1 99/10/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;
 
import java.awt.event.*;

class TextComponent extends Component {

  int caretPos;
  int caretPos0;

  String text = "";
    
  boolean editable;
  TextListener textListener;

  /** Caution: In contrast to the AWT, KAWT supports 
   *	only one TextListener! 
   */

  public void addTextListener (TextListener tl) {
	if (textListener != null) 
	    throw new TooManyListenersException ();
	
	textListener = tl;
  }


  public int getCaretPosition () {
	return getSelectionStart ();
  }


  public String getSelectedText () {
	return text.substring (getSelectionStart (), getSelectionEnd ());
  }

  public int getSelectionStart () {
	if (caretPos < caretPos0) 
	    return caretPos;
	else 
	    return caretPos0;
  }
		
  public int getSelectionEnd () {
	if (caretPos > caretPos0) 
	    return caretPos;
	else 
	    return caretPos0;
  }
		

  public String getText () {
	return text;
  }

  public boolean isEditable () {
	return editable;
  }



  public void processTextEvent (TextEvent te) {
	if (textListener != null) 
	    textListener.textValueChanged (te);
  }

    
  public void removeTextListener (TextListener tl) {
	textListener = null;
  }

  public void select (int start, int end) {
	caretPos0 = start;
	caretPos = end;
	repaint ();
  }

  public void selectAll () {
	caretPos0 = 0;
	caretPos = text.length ();
	repaint ();
  }
	

  public void setEditable (boolean ed) {
	if (ed != editable) {
	    editable = ed;
	    repaint ();
	}
  }


  public void setCaretPosition (int cp) {
	if (cp < 0) cp = 0;
	if (cp > text.length ()) cp = text.length ();
	
	if (caretPos != cp || caretPos0 != cp) {
	    caretPos = cp;
	    caretPos0 = cp;
	    repaint ();
	}
  }

  public void setSelectionStart (int i) {
	caretPos0 = i;
  }


  public void setSelectionEnd (int i) {
	caretPos = i;
  }


  public void setText (String newText) {
	if (!text.equals (newText)) {
	    text = newText;
	    
	    repaint ();
	    
	    if (textListener != null)
		processTextEvent 
		    (new TextEvent 
		     (this, TextEvent.TEXT_VALUE_CHANGED));
	}
  }   
}

    
