/*
 * Button.java Version 0.11 99/11/07
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import java.util.*;
import java.awt.event.*;

public class Button extends Component {  
  private ActionListener actionListener = null;

  int minW;
  int minH;

  String label;
  String command;

  boolean pressing = false;

  public Button (String s) {
	setLabel (s);

	h = minH;
	w = minW;
  }
  

    public void addActionListener(ActionListener al) {
	if (actionListener != null) 
	    throw new TooManyListenersException ();
	
	actionListener = al;  
    }
    

    public Dimension getMinimumSize () {
	return new Dimension (minW, minH);
    }
    
    public void paint (Graphics g) {
	g.drawString (label, (w-minW)/2+2, 
		      (h+minH)/2-2); 
	g.drawRoundRect (0, 0, w, h, 3, 3);
  }
    
    public void processMouseEvent (MouseEvent me) {
	boolean inRange =  me.getX () >= 0 && me.getX () <= w 
	    && me.getY () >= 0 && me.getY () <= h;
	
	boolean isPressing = me.getID () == MouseEvent.MOUSE_PRESSED 
	    || (me.getID () == me.MOUSE_DRAGGED && inRange);

	if (isPressing != pressing) {
	    pressing = !pressing;
	    Graphics g = getGraphics ();
	    if (g != null) {
		g.setXORMode (Color.black);
		g.fillRoundRect (1, 1, w-2, h-2, 2, 2);
	    }
	}

	if (inRange 
	    && me.getID () == MouseEvent.MOUSE_RELEASED
	    && actionListener != null)
	    
	    actionListener.actionPerformed 
		((new ActionEvent 
		  (this, ActionEvent.ACTION_PERFORMED, command)));
		 
  }

    /*
    public void processActionEvent (ActionEvent e) {
	if (actionListener != null) 
	    actionListener.actionPerformed (e);
    }
    */
  
  public void removeActionListener(ActionListener al) {
	if (al == actionListener)
	    actionListener = null;
  }
    
  public void setActionCommand (String s) {
	command = s;
  }

  public void setLabel (String s) {
	this.label = s;

	minW = com.sun.kjava.Graphics.getWidth(s)+4;
	minH = com.sun.kjava.Graphics.getHeight (s)+2;

	if (minW > w) invalidate ();
  }
}








