/*
 * Container.java Version 0.11 99/11/07
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

import java.util.Vector;
import java.awt.event.*;


public class Container extends Component {

  static Insets nullInsets = new Insets (0, 0, 0, 0);

  Vector children = new Vector ();
  //    Vector constraints;
  LayoutManager layoutManager = FlowLayout.defaultLayout;
  protected Insets insets = nullInsets;

  public Container() {
  }


  public Container (LayoutManager layoutManager) {
	this ();
	this.layoutManager = layoutManager;
  }


  public Component add (Component component) {
	add (null, component);
	return component;
  }


  public Component add (String where, Component c) {
	children.addElement(c);
	c.parent = this;
	//	constraints.add (where);
	layoutManager.addLayoutComponent (where, c);
	return c;
  }

  /*  included in validate directly in order to save stack space
  public void doLayout () {
    if (layoutManager != null)
	  layoutManager.layoutContainer (this);
  }
  */

  public Component findComponentAt (int px, int py) {
	
	if ((!visible) || !contains (px, py)) return null;

	for (int i = 0; i < children.size(); i++) {
	    Component c = (Component) children.elementAt (i);

	    c = c.findComponentAt (px - c.x, py - c.y);
	    
	    if (c != null) return c;
	}
	return this;
  }

    
    public Component getComponent (int i) {
	return (Component) children.elementAt (i);
    }

  
  public Dimension getMinimumSize () {
	return layoutManager.minimumLayoutSize (this);
  }


  public LayoutManager getLayout () {
	return layoutManager;
  }


  public void paintAll (Graphics g) {
	if (visible && g != null) {
	    paint (g.create ());

	    //    paintComponents (g);
	    //  save some stack space (uahrg!)

	    for (int i = 0; i < children.size(); i++) {
		Component child = (Component) children.elementAt (i);
		child.paintAll 
		    (g.create (child.x, child.y, child.w, child.h));
	    }
	}
  }
    
             
  public void paintComponents (Graphics g) {
	
	for (int i = 0; i < children.size(); i++) {
	    Component child = (Component) children.elementAt (i);
	    child.paintAll 
		(g.create (child.x, child.y, child.w, child.h));
	}
  }
    
 
  public void remove(Component c) {
	children.removeElement (c);
	if (c.visible) valid = false;
  }


  public void setLayout (LayoutManager mgr) {
	layoutManager = mgr;
	invalidate ();

	/*for (int i = 0; i < children.size (); i++) 
	    mgr.addLayoutComponent ((String) constraints.get (i), 
				    (Component) children.get (i));
	*/
  }

  public void validate () {

	if (!valid) {

	    if (layoutManager != null) layoutManager.layoutContainer (this);
	    //doLayout ();
	    for (int i = 0; i < children.size (); i++) 
		((Component) children.elementAt (i)).validate ();
	    
	    valid = true;
	}
  }


  public void update (Graphics g) {
	if (g== null) return;

	g.clearRect (0, 0, w, h); 
	paintAll (g);
  }
}