/*
 * List.java Version 0.11 99/11/07 
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *					   - flickering while itemselection fixed
 *					   - list srolls now while dragging out of
 *						 the list area
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

import java.awt.event.*;
import java.util.Vector;

/** the List is currently only used as helper class for the choice since
 *  scrolling is not yet implemented
 */

public class List extends Component {
    
    Vector elements = new Vector ();
    
    int lineH = 12;
    int sel = -1;
    Choice choice;
    Scrollbar scrollbar;
    
    ItemListener itemListener;
    
    public List () {
    }

    List (Choice choice) {
	this.choice = choice;
    }
    
    public void add (String item) {
	elements.addElement (item);
	repaint ();
    }

    
    public void addItemListener (ItemListener il) {
	if (itemListener != null) 
	    throw new TooManyListenersException ();
	
	itemListener = il;
    }

    
    public void removeAll () {
	elements.removeAllElements ();
    }

    public Dimension getMinimumSize () {
	int border = (choice == null) ? 2 : 4;
	return new Dimension 
	    (50 + border + 2, elements.size () * lineH + border);
    }
    
    
    public String getSelectedItem () {
	if (sel < 0 || sel >= elements.size ()) return null;
	return (String) elements.elementAt (sel);
    }


    public void update (Graphics g) {
	paint (g);
    }
    
    public void paint (Graphics g) {
	
	if (choice != null) {
	    g.drawLine (2, 1, w-3, 1);
	    g.drawLine (2, h-2, w-2, h-2);
	    g.drawLine (3, h-1, w-3, h-1);

	    g.drawLine (1, 2, 1, h-3);
	    g.drawLine (w-2, 2, w-2, h-2);
	    g.drawLine (w-1, 3, w-1, h-3);
	}
	else 
	    g.drawRect (0,0,w,h);

	int border = (choice == null) ? 1 : 2;


	// care abt scrollbar pos and size here only!
	int visible = (h - 2 * border) / lineH;

	if (visible < elements.size ()) {
 	    if (scrollbar == null) {
		scrollbar = new Scrollbar (); 
		scrollbar.internalOwner = this;
		scrollbar.setSize (scrollbar.getMinimumSize ());
	    }

	    scrollbar.maxValue = elements.size () - visible;
	    scrollbar.currVisible = visible;
	    scrollbar.blockIncrement = visible;
	    
	    scrollbar.h = h - border-border;

	    scrollbar.paint 
		(g.create (w - scrollbar.w-border, border, 
			   scrollbar.w, scrollbar.h));

	    g = g.create (border, border, 
			  w - scrollbar.w-border-border, 
			  h - border - border);
	    // create new graphics with new clipping here
	}
	else {
	    g = g.create (border, border, w - border*2, h - border*2);
	    scrollbar = null;
	}


	// draw list

	int i = (scrollbar == null) ? 0 : scrollbar.currValue;
	int ty = 0;
	
	while ( ty < h) {
	    // XXX change in Graphics (baseline!)
	    
	    g.setColor (Color.white);
	    g.fillRect (0, ty, w-border-border, lineH);

	    if (i < elements.size ()) {
		g.setColor (Color.black);
		g.drawString (""+elements.elementAt (i), border+1, 
			      ty+lineH-1); 
       
		if (i == sel) {
		    g.setXORMode (Color.black);
		    g.fillRect (0, ty, w-border-border, lineH);
		    g.setPaintMode ();
		}
	    }

	    i++;
	    ty += lineH;
	}
  }


  public void processMouseEvent (MouseEvent me) {
	if (scrollbar != null 
	    && me.getX () > w - scrollbar.w - 2) {
	    me.translatePoint (- (w - scrollbar.w -2), -1);
	    scrollbar.processMouseEvent (me);
	    return;
	}

      
	if (choice != null && me.getID () == me.MOUSE_RELEASED) {
	    choice.win.setVisible (false);
	    return;
	}

	if (me.getID () != me.MOUSE_DRAGGED 
	    && me.getID () != me.MOUSE_PRESSED) return;

	int newSel = ((scrollbar == null) ? 0 : scrollbar.currValue) 
	    + me.getY () / lineH;

	if (newSel < 0) newSel = 0;
	if (newSel >= elements.size ()) newSel = elements.size () -1;
	
	else if (sel != newSel) {
	    sel = newSel;

	    if (scrollbar != null) {
		if (sel < scrollbar.currValue) 
		    scrollbar.currValue = sel;
		else if (sel > scrollbar.currValue + scrollbar.currVisible) 
		    scrollbar.currValue = sel - scrollbar.currVisible;
	    }
	    repaint ();
	}
  }
}