/*
 * KeyEvent.java Version 0.12 99/11/22 
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *			(99/11/22) Version number 0.12 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt.event;

import java.awt.*;

public class KeyEvent extends AWTEvent {

  public static final int KEY_PRESSED = 0x0301;
  public static final int KEY_RELEASED = 0x0302;
  public static final int KEY_TYPED = 0x0303;

  public static final char CHAR_UNDEFINED = 0;
  public static final int VK_UNDEFINED = 0;
 
  public static final int VK_BACK_SPACE = 8;
  public static final int VK_LEFT = 28;
  public static final int VK_PAGE_DOWN = com.sun.kjava.Spotlet.PAGEDOWN;
  public static final int VK_PAGE_UP = com.sun.kjava.Spotlet.PAGEUP;
  public static final int VK_RIGHT = 29;

  int keyCode;
  char keyChar;

  public KeyEvent (Component source, int id, long when, 
                   int modifiers, int keyCode) {
	this (source, id, when, modifiers, keyCode, CHAR_UNDEFINED);
  } 
	    
  public KeyEvent (Component source, int id, long when, int modifiers, 
  	               int keyCode, char keyChar) {

	super (source, id);
           
	this.keyCode = keyCode;
	this.keyChar = keyChar;
  }

  public char getKeyChar () {
	return keyChar;
  }

  public int getKeyCode () {
	return keyCode;
  }
}