/*
 * SpotletWrapper.java Version 0.2 99/11/28
 *
 * History: 
 *  99/10/22 Version number 0.1 released
 *  99/11/07 Version number 0.11 released
 *  99/11/24 Changes for 0.2 synchronized constants with original awt
 *  99/11/24 MK Version number 0.2 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

import com.sun.kjava.Spotlet;
import java.awt.event.*;

class SpotletWrapper extends Spotlet {

    Frame frame;
    //    static SpotletWrapper activeSpotlet;

    Component mouseOwner;
    int mouseOrgX;
    int mouseOrgY;
    
    public SpotletWrapper (Frame frame) {
	register (NO_EVENT_OPTIONS);
	
	this.frame = frame;
	/*
	  Caret.caret = new Caret ();
	  Caret.caret.start ();
	*/
    }
    
    
    public void keyDown (int keyCode) {
	
	if (frame == null) return;
	
	Component focus = frame.getTopWindow ().focus; 
	
	if (focus == null) return;

	if (keyCode < 31 || keyCode > 128) { 
	    switch (keyCode) {
	    case 28: keyCode = KeyEvent.VK_LEFT; break;
	    case 29: keyCode = KeyEvent.VK_RIGHT; break;
	    case PAGEDOWN: keyCode = KeyEvent.VK_PAGE_DOWN; break;
	    case PAGEUP: keyCode = KeyEvent.VK_PAGE_UP; break;
	    }

	    focus.processKeyEvent 
		(new KeyEvent (frame.getTopWindow (), 
			       KeyEvent.KEY_PRESSED, 0, 0,
			       keyCode, KeyEvent.CHAR_UNDEFINED));
	}
	else
	    focus.processKeyEvent 
		(new KeyEvent (frame.getTopWindow (), 
			       KeyEvent.KEY_TYPED, 0, 0,
			       KeyEvent.VK_UNDEFINED, (char) keyCode));
    }  
    
    
    public void penDown (int x, int y) {

	if (frame == null) return;

	Window topWindow = frame.getTopWindow ();
	Point p = topWindow.getLocationOnScreen ();

	mouseOwner = topWindow.findComponentAt (x - p.x, y - p.y);

	if (mouseOwner != null) {
	    p = mouseOwner.getLocationOnScreen ();
	
	    mouseOrgX = p.x;
	    mouseOrgY = p.y;
	    
	    mouseOwner.processMouseEvent
		(new MouseEvent (this, MouseEvent.MOUSE_PRESSED, 0, 0, 
				 x-mouseOrgX, y-mouseOrgY));
	}
	else if (topWindow.isMenu) 
	    topWindow.setVisible (false); 
    }
    
    
    public void penUp (int x, int y) {

	if (mouseOwner == null) return;

	x -= mouseOrgX;
	y -= mouseOrgY;

	mouseOwner.processMouseEvent 
	    (new MouseEvent (this, MouseEvent.MOUSE_RELEASED, 0, 0, x, y));
	
	
	mouseOwner.processMouseEvent 
	    (new MouseEvent (this, MouseEvent.MOUSE_CLICKED, 0, 0, x, y));
  }
    

    public void penMove (int x, int y) {
	if (mouseOwner != null) 
	    mouseOwner.processMouseEvent 
		(new MouseEvent (this, MouseEvent.MOUSE_DRAGGED, 0, 0, 
				 x-mouseOrgX, y-mouseOrgY));
    }
}