/*
 * WindowListener.java Version 0.2 99/11/28
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 * 			(99/11/22) Version number 0.12 released
 * 			(99/11/28) Version number 0.2 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt.event;

  /**
   * The listener interface for receiving window events. The class that is 
   * interested in processing a window event either implements this interface 
   * (and all the methods it contains) or extends the abstract WindowAdapter class 
   * (overriding only the methods of interest). The listener object created from that
   * class is then registered with a Window using the winodw's addWindowListener 
   * method. When the window's status changes by virtue of being opened, closed, 
   * activated or deactivated, iconified or deiconified, the relevant method in 
   * the listener object s invoked, and the WindowEvent is passed to it.
   *
   * @author  Stefan Haustein / Michael Kroll
   */


public interface WindowListener {
 
  /**
   * Invoked when the window is set to be the user's active window, 
   * which means the window (or one of its subcomponents) will receive 
   * keyboard events.
   */

  void windowActivated (WindowEvent e); 

  /**
   * Invoked when a window has been closed as the result of calling dispose on the window.
   */

  void windowClosed (WindowEvent e); 

  /**
   * Invoked when the user attempts to close the window from the window's system menu.
   */

  void windowClosing (WindowEvent e); 

  /**
   * Invoked when a window is no longer the user's active window, which means 
   * that keyboard events will no longer be delivered to the window or 
   * its subcomponents.
   */

  void windowDeactivated (WindowEvent e); 

  /**
   * Invoked when a window is changed from a minimized to a normal state.
   */

  void windowDeiconified (WindowEvent e);

  /**
   * Invoked when a window is changed from a normal to a minimized state.
   */

  void windowIconified (WindowEvent e); 

  /**
   * Invoked the first time a window is made visible.
   */

  void windowOpened (WindowEvent e); 
}