// Authors: Stefan Haustein (SH), Michael Kroll (MK)
// 1999-08-19 SH initial release
// 1999-08-29 SH added TestDialog
// 1999-09-02 MK added TabbedPane
// 1999-11-07 MK version 0.11 released
// 1999-11-22 MK version 0.12 released
// 1999-11-28 MK version 0.2 released
// 1999-12-05 MK version 0.21 released

import java.awt.*;
import java.awt.event.*;
import de.trantor.kawt.*;

class LayoutPanel extends Panel implements ActionListener {

  LayoutManager saveBorder;
  TestDialog dialog; 

  LayoutPanel (Frame frame) {

	super (new BorderLayout ());
	dialog = new TestDialog (frame);
	addButton ("North", "grid");
	addButton ("South", "border");
	addButton ("East", "flow");
	addButton ("West", "exit");
	addButton ("Center", "dialog");
	saveBorder = getLayout ();
	validate ();
  }

  void addButton (String where, String label) {
	Button b = new Button (label);
	add (where, b);
	b.addActionListener (this);
	b.setActionCommand (label);
  }
   
  public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("grid")) 
      setLayout (new GridLayout (3, 2));
	else if (cmd.equals ("flow"))
      setLayout (new FlowLayout ());
	else if (cmd.equals ("border"))
      setLayout (saveBorder);
	else if (cmd.equals ("dialog")) 
      dialog.show ();
	else if (cmd.equals ("exit")) 
      System.exit (0);
	validate ();
  }
}

class MiscPanel extends Panel implements ActionListener, ItemListener { 
  Frame frame;
  MiscPanel (Frame frame) {
	super (new GridLayout (0, 1));
	this.frame = frame;
	CheckboxGroup group = new CheckboxGroup ();
	add (new Checkbox ("RadioButton 1", group, false)); 
	add (new Checkbox ("RadioButton 2", group, false));
	Checkbox titlebox = new Checkbox ("Show Frame Title", true);
	titlebox.addItemListener (this);
	add (titlebox);
	add (new TextField ("Test"));
	Choice choice = new Choice ();
	choice.add ("red");
	choice.add ("green");
	choice.add ("blue");
	add (choice);
	addButton ("beep");
	addButton ("exit");
  }

  void addButton (String label) {
    Button b = new Button (label);
	add (b);
	b.addActionListener (this);
	b.setActionCommand (label);
  }

  public void itemStateChanged (ItemEvent ev) {
 	if (ev.getStateChange () == ev.SELECTED) 
      frame.setTitle ("kAWT Sample v0.21");
	else 
      frame.setTitle (null);
	frame.validate ();
  }

  public void actionPerformed (ActionEvent ev) {
	if (ev.getActionCommand ().equals ("beep")) {
      Toolkit.getDefaultToolkit ().beep ();
	}
	else System.exit (0);
  }
}

class ScrollbarPanel extends Panel implements AdjustmentListener, ActionListener {
  Label label;
  Scrollbar horizontal;

  ScrollbarPanel (Frame frame) {
	super (new BorderLayout ());
	Button exitB = new Button ("exit");
	exitB.addActionListener (this);
	exitB.setActionCommand ("exit");
	add ("West", exitB);

	label = new Label ();
	horizontal = new Scrollbar (Scrollbar.HORIZONTAL);
	horizontal.addAdjustmentListener (this);

	List list = new List ();
	for (int i= 0; i < 20; i++)	
      list.add ("item "+i);

	add ("North", label);
	add ("Center", list);
	add ("South", horizontal);
	adjustmentValueChanged (null);
	validate ();
  }

  public void adjustmentValueChanged (AdjustmentEvent ev) {
	label.setText ("Pos h: "+horizontal.getValue ());
  }

  public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("exit")) 
      System.exit (0);
  }
}

class TestDialog extends Dialog implements ActionListener {
  TestDialog (Frame w) {
	super (w, "Sample Dialog");
	Panel panel = new Panel (new GridLayout (4, 1));
	add ("Center", new Label ("kAWT sample Dialog"));
	panel = new Panel ();
	Button button = new Button ("Close");
	button.addActionListener (this);
	panel.add (button);
	add ("South", panel);
	pack ();	
  }

  public void actionPerformed (ActionEvent e) {
	setVisible (false);
  }
}

class Closer extends WindowAdapter {
  public void windowClosing (WindowEvent e) {
	System.exit (0);
  }
}

public class KawtSample extends Frame {
  Dialog dialog;
  TabbedPane tabPane;

  KawtSample () {
	setTitle ("kAWT Sample v0.21");
    Runtime.getRuntime().gc();
	tabPane = new TabbedPane();
	tabPane.addTab ("Layout", new LayoutPanel (this));
	tabPane.addTab ("Misc", new MiscPanel (this));
	tabPane.addTab ("Scrollbar", new ScrollbarPanel (this));
	add ("Center", tabPane);

	addWindowListener (new Closer ());

	pack ();
  }

  public static void main (String [] argv) {
	new KawtSample ().show ();
  }
}