/*
 * CardLayout.java Version 0.21 99/12/05
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *			(99/11/22) Version number 0.12 released
 *			(99/11/28) Version number 0.2 released
 *			(99/12/05) Version number 0.21 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * stefan.haustein@trantor.de
 *
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import java.util.Vector;

public class CardLayout implements LayoutManager {

  Vector cards=new Vector();
  Vector names=new Vector();
  int selected;

  public void addLayoutComponent (String name, Component card) {
  	card.visible = cards.size() == selected;
	names.addElement (name);
	cards.addElement (card);
  }

  public void first (Container parent) {
	show (0);
  }

  public void last (Container parent) {
	show (cards.size () - 1);
  }

  public void layoutContainer (Container parent) {
    for (int i = 0; i < cards.size(); i++){
	  Component c = (Component) cards.elementAt(i);
	    
	  c.x = parent.insets.left;
	  c.y = parent.insets.top;
	  c.w = parent.w - c.x - parent.insets.right;
	  c.h = parent.h - c.y - parent.insets.bottom;

	  c.valid = false;
	}
  }


  public Dimension minimumLayoutSize (Container parent) {

	int w=0;
	int h=0;

	for (int i=0;i<cards.size();i++){
	  Component c = (Component) cards.elementAt(i);
	  Dimension d = c.getMinimumSize();

	  if(w<d.width) w=d.width;
	  if(w<d.width) w=d.width;
	}
	return new Dimension (w,h);
  }
    
  public void next (Container parent) {
	if (selected < cards.size ()-1)
	  show (selected + 1);
    else 
	  show (0);
  }

  public void previous (Container parent) {
	if (selected > 0)
	  show (selected - 1);
	else 
	  last (parent);
  }
		
  public void show (Container parent, String name){
	show (names.indexOf (name));
  }

  void show (int i) {
	if (i == -1 || i == selected || i >= cards.size ()) return;
	((Component) cards.elementAt(selected)).visible = false;
	selected=i;
	((Component) cards.elementAt(selected)).setVisible (true);
  }    

  public void removeLayoutComponent (Component card) {
	int i=cards.indexOf (card);
	if (i==selected) show (i > 0 ? i : 0);
  	cards.removeElementAt(i);
	names.removeElementAt(i);
	if (selected > i) selected--;
  }
}