/*
 * Image.java Version 0.21 99/12/05
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *			(99/11/22) Version number 0.12 released
 *			(99/11/28) Version number 0.2 released
 *			(99/12/05) Version number 0.21 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

/** currently, only wrapper for palm image with hidden constructor
 *  for kAWT internal usage only.
 *
 */  

public class Image {
  com.sun.kjava.Bitmap bitmap; 
    
  static int hexToDec (char c) {
	if (c >= '0' && c <= '9') return ((int) c) - ((int) '0');
	if (c >= 'a' && c <= 'f') return 10 + ((int) c) - ((int) 'a');
	if (c >= 'A' && c <= 'F') return 10 + ((int) c) - ((int) 'A');
	throw new RuntimeException ("Illegal Char:"+c);
  }


  Image (int w, int h, int depth, byte [] data) {
	
	int byteW = (w+7)/8;

	if (byteW*h != data.length) 
	    throw new RuntimeException ("bw*h!=data.lengt");

	bitmap = new com.sun.kjava.Bitmap ((short) byteW , data);
  }
	

  Image (int w, int h, int depth, String hexdata) {
	
	int byteW = (w+7)/8;
	
	if (byteW * h * 2 != hexdata.length ()) 
	    throw new RuntimeException ("bw*h*2!=data.lengt");

	byte [] data = new byte [hexdata.length() / 2];

	int cp = 0;
	int i = 0;
	while (cp < hexdata.length ()) {
	    data [i++] = (byte) (hexToDec (hexdata.charAt (cp)) * 16 
		+ hexToDec (hexdata.charAt (cp+1)));
	    cp += 2;
    }
	    
    bitmap = new com.sun.kjava.Bitmap ((short) byteW, data);
  }
}