/*
 * Graphics.java Version 0.22 99/12/15
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *			(99/11/22) Version number 0.12 released
 *			(99/11/28) Version number 0.2 released
 *			(99/12/05) Version number 0.21 released
 *			(99/12/15) Version number 0.22 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import com.sun.kjava.*;

public class Graphics {

  static Graphics current;
  static Object lock = new Object ();

  int originX;
  int originY;

  Color color = Color.black;
  boolean xorMode = false;
  Font font = Font.defaultFont;

  int nativeDrawMode = com.sun.kjava.Graphics.PLAIN;
    
  int clipX;
  int clipY;
  int clipW;
  int clipH;

  public Graphics () {
	originX = 0;
	originY = 0;
	clipX = 0;
	clipY = 0;
	clipW = 160;
	clipH = 160;
  }
    
  public Graphics create () {
	Graphics g = new Graphics ();
	g.originX = originX;
	g.originY = originY;
	g.nativeDrawMode = nativeDrawMode;
	g.xorMode = xorMode;
	g.color = color;
	g.clipX = clipX;
	g.clipY = clipY;
	g.clipW = clipW;
	g.clipH = clipH;
	return g;
  }
    
    
  public Graphics create (int x, int y, int width, int height) {
	Graphics g = create();
	g.translate (x, y);
	g.clipRect (0, 0, width, height);
	return g;
  }
    

  public void checkContext () {
	if (current != this) {
	    current = this;
	    com.sun.kjava.Graphics.setDrawRegion (clipX, clipY, clipW, clipH);
	}
  }
	
  public void clipRect (int x, int y, int w, int h) {
	current = null;
	x += originX;
	y += originY;
	if (x > clipX) {
	    clipW -= x - clipX;
	    clipX = x;
	}
	if (y > clipY) {
	    clipH -= y - clipY;
	    clipY = y;
	}
	if (x + w < clipX + clipW)
	    clipW = x + w - clipX;
	if (y + h < clipY + clipH)
	    clipH = y + h - clipY;
  }

  public void setClip (int x, int y, int w, int h) {
	current = null;
	clipX = x + originX;
	clipY = y + originY;
	clipW = w;
	clipH = h;
  }

  public void clearRect (int x, int y, int w, int h) {
	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawRectangle 
		(originX+x, originY+y, w, h, com.sun.kjava.Graphics.ERASE, 0);
	}
  }


  public void drawImage (Image image, int x, int y, 
			   Object observer) {

	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawBitmap 
		(x + originX, y+originY, image.bitmap);
	}
  }
    
  public void drawLine (int x1, int y1, int x2, int y2) {
	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawLine 
		(x1+originX, y1+originY, x2+originX, y2+originY, nativeDrawMode);
	}
  }
    

  public void drawPolyline (int[] xPoints, int[] yPoints, int nPoints) {
	synchronized (lock) {
	    checkContext ();
	    for (int i = 0; i < nPoints - 1; i++) {
  		  com.sun.kjava.Graphics.drawLine 
		    (xPoints[i] + originX, yPoints[i] + originY, 
		     xPoints[i+1] + originX, yPoints[i+1] + originY, 
		     nativeDrawMode);
	    }
	}
  }
    

  public void drawRoundRect (int x, int y, int width, int height, 
	               	         int arcWidth, int arcHeight) {

	int arc =  (arcWidth+arcHeight) / 2;
	
	if (arc > 0x0fff) arc = 0x0fff;

	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawBorder
		(originX+x+1, originY + y+1, width-2, height-2, 
		 nativeDrawMode, arc << 8 | 1);
	}
  }

  public void drawString (String text, int x, int y) {
	synchronized (lock) {
	    checkContext ();

	    y += originY - 10;  // font pos = baseline in AWT!!!!
	    x += originX;

	    if (!font.isBold ())
		com.sun.kjava.Graphics.drawString 
		    (text, x, y, nativeDrawMode);
	    else {
		for (int i = 0; i < text.length (); i++) {
		    String cc = ""+text.charAt (i);
		    com.sun.kjava.Graphics.drawString 
			(cc, x++, y, nativeDrawMode);
		    com.sun.kjava.Graphics.drawString 
			(cc, x, y, nativeDrawMode);
		    x += com.sun.kjava.Graphics.getWidth (cc);
		}
      }
	}
  }


  public void drawOval (int x, int y, int w, int h) {
	int d = w;
	if (h < d) d = h;
	
	d += 2;

	drawRoundRect (x - 1, y -1, w+2, h+2, d, d);
  }
    

  public void drawRect (int x,  int y, int width, int height) {
	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawBorder
		(originX+x+1, originY + y+1, width-2, height-2, nativeDrawMode, 1);
	}
  }
    
  public void fillRect (int x, int y, int width, int height) {
	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawRectangle 
		(originX+x, originY+y, width, height, nativeDrawMode, 0);
	}
  }
    
  
  public void fillRoundRect (int x, int y, int width, int height, 
			                 int arcWidth, int arcHeight) {
	synchronized (lock) {
	    checkContext ();
	    com.sun.kjava.Graphics.drawRectangle 
		(originX+x, originY+y, width, height, nativeDrawMode, 
		 (arcWidth+arcHeight) >> 1);
	}
  }

    
  public Font getFont () {
	return font;
  }


  public FontMetrics getFontMetrics () {
	return new FontMetrics (font);
  } 


  public FontMetrics getFontMetrics (Font font) {
	return new FontMetrics (font);
  } 


  public void setColor (Color c) {
	color = c;
	if (!xorMode) {
	    int sum = ((c.rgb & 0x0ff0000) >> 16) 
		+ ((c.rgb & 0x0ff00) >> 8)
		+ (c.rgb & 0x0ff);

	    if (sum > 256)
		if (sum > 512) nativeDrawMode = com.sun.kjava.Graphics.ERASE;
		else nativeDrawMode = com.sun.kjava.Graphics.GRAY;
	    else nativeDrawMode = com.sun.kjava.Graphics.PLAIN;			  
	}
  }
	

  public void setFont (Font font) {
	this.font = font;
  }


  public void setPaintMode () {
	xorMode = false;
	setColor (color);
  }


  public void setXORMode (Color c2) {
	xorMode = true;
	nativeDrawMode = com.sun.kjava.Graphics.INVERT;
  }
	

  public void translate (int x, int y) {
	originX += x;
	originY += y;
  }
}