/*
 * Window.java Version 0.22 99/12/15
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *			(99/11/22) Version number 0.12 released
 *			(99/11/28) Version number 0.2 released
 *			(99/12/05) Version number 0.21 released
 *			(99/12/15) Version number 0.22 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */


package java.awt;

import java.awt.event.*;
import java.util.Vector;

/** The Window class currently does not support windows 
 *  outside the owner window. Also adding child windows
 *  to windows not on top of the stack may produce strange results
 *  <p>  
 *  I'll fix that after implementation of restricted area repaint.
 *  <p>
 *  Stefan
 */

public class Window extends Container {

    Frame owner;
    Component focus;
    boolean isMenu = false; // close if clicking elsewhere

    /*
    Window (int w, int h) {  // private constructor for "screen" window
	super (null); 
	
	valid = true;
	
	width = w;
	height = h;
	
	// visible is true by default
	// x = 0;  also by default
	// y = 0;
    }
    */

    /*
    public Window (Window w) {
	super (new BorderLayout ());
	if (w == null) 
	    throw new NullPointerException ();
	owner = w;
	if (owner.windows == null) owner.windows = new Vector ();
	owner.windows.addElement (this);
	visible = false;

	width = SpotletWrapper.screen.width;
	height = SpotletWrapper.screen.height;
    }
    */

    public Window (Frame f) {
	super (new BorderLayout ());
	
	owner = f;
	visible = false;
    }

    
    /** This method does not do anything and is included
     *  for compatibility only
     */

    public void addWindowListener (WindowListener l) {
    }
    

    public void dispose () {
	setVisible (false);
    }


    public Component getFocusOwner () {
	return focus;
    }
    
    /** returns null if not visible */

    public Point getLocationOnScreen () {

	return (owner.getTopWindow () == this) ? new Point (x, y) : null;
    }
    

    public Toolkit getToolkit () {
	return Toolkit.defaultToolkit;
    }


    public void pack () {
	setSize (getPreferredSize ());
	validate ();
	x = 0;
	y = 160 - h;
    }
    
 
    public void proxyRequestFocus (Component fc) {
	if (focus != null) {
	    focus.hasFocus = false;
	    focus.repaint ();
	    
	    //  if (focus instanceof TextField)
		//Caret.caret.setVisible (false);
	}
	
	focus = fc;

	//if (focus instanceof TextField)
	    //Caret.caret.setVisible (true);

	focus.hasFocus = true;
	focus.repaint ();
    }
    
  
    public void setVisible (boolean vis) {
	if (vis != visible) {

	    if (vis) {
		if (this != owner)
		    owner.windows.addElement (this);

		visible = true;
		repaint ();
	    }
	    else if (this == owner) 
		visible = false;
	    else {
		owner.windows.removeElement (this);
		visible = false;
		owner.repaint (x, y, w, h);
	    }
	}
    }	
    

  public void show () {
	setVisible (true);
  }
}