/*
 * TextField.java Version 0.11 99/11/07
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 *  OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 *  PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK
 *  AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 *  REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 *  REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
 *  DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT
 *  LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 *  YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS
 */

package java.awt;

import java.awt.event.*;

/** Limitations
    <ul>
    <li>The caret blinking is currently disabled because of often system 
    crashes when running threads
    <li>ActionEvents are not sent (but TextEvents)
    </ul>
*/

public class TextField extends TextComponent {
    
    int minW;
    static final int minH = 12;
    int scrollOffset = 0;
    
    public TextField () {
	this ("", 10);
    }
    
    public TextField (int cols) {
	this ("", cols);
    }
    

    public TextField (String s) {
	this (s, 10);
    }



    public TextField (String text, int cols) {
	h = minH;
	minW = 7*cols;
	w = minW;
	setText (text);
    }


    public Dimension getMinimumSize () {
	return new Dimension (minW, minH);
    }


    public void paint(Graphics g) {
	int middle = h/2;
	int scrCaretPos = 0;
	
	if (hasFocus) {
	    Point los = getLocationOnScreen (); 
	    
	    scrCaretPos = com.sun.kjava.Graphics.getWidth 
		(text.substring (0, caretPos));
	    
	    if (scrCaretPos - scrollOffset > w 
		|| scrCaretPos - scrollOffset < 0) { 
		if (scrCaretPos < w) scrollOffset = 0;
		else scrollOffset = scrCaretPos - w / 2;
	    }
	    //	    Caret.caret.setPosition 
	    //	(los.x + scrCaretPos - scrollOffset, los.y+middle-5);
	    
	}
	else scrollOffset = 0;
	
	g.drawString (text, -scrollOffset, middle+5);
	
	g.setColor (Color.gray);
	g.drawLine (0, middle+5, w, middle+5);
	
	if (hasFocus) {
	    int scrCaretPos0 = com.sun.kjava.Graphics.getWidth 
		(text.substring (0, caretPos0));
	    
	    g.setColor (Color.black);
	    g.setXORMode (Color.black);

	    int cw = scrCaretPos - scrCaretPos0;
	    if (cw < 0) cw = -cw;
	    if (cw < 2) cw = 2;

	    if (scrCaretPos0 < scrCaretPos)
		g.fillRect (scrCaretPos0-scrollOffset, middle-5, 
			    cw, 10); 
	    else
		g.fillRect (scrCaretPos-scrollOffset, middle-5,
			    cw, 10); 
	}
    }
    

    public void processMouseEvent (MouseEvent me) {
	if (!hasFocus) 
	    requestFocus ();
	
	int cp = 0;
	
	int mx = me.getX () + scrollOffset;
	int w = 0;
	
	while (w < mx && cp < text.length ()) {
	    w += com.sun.kjava.Graphics.getWidth 
		(text.substring (cp, cp+1));
	    cp++;
	}

	if (me.getID () == me.MOUSE_PRESSED)  
	    caretPos0 = cp;
	    
	if (cp != caretPos || me.getID () == me.MOUSE_PRESSED) {
	    caretPos = cp;
	    repaint ();
	}
  }


  public void processKeyEvent (KeyEvent ke) {

	int p0 = getSelectionStart ();
	int p1 = getSelectionEnd ();

	caretPos = p0;
	caretPos0 = p0;
	
	if (ke.getID () == ke.KEY_TYPED) { 
	    caretPos++;
	    caretPos0 = caretPos;
	    
	    setText (text.substring (0, p0) 
		     + ke.getKeyChar ()
		     + text.substring (p1, text.length ()));   
	}
	else {
	    int kc = ke.getKeyCode ();
	    switch (kc) {
	    case ke.VK_LEFT:
		setCaretPosition (p0-1);
		break;

	    case ke.VK_RIGHT:
		setCaretPosition (p1+1);
		break;

	    case ke.VK_BACK_SPACE:  
		if (caretPos > 0) caretPos--;
		caretPos0 = caretPos;

		if (p0 <= 1) 
		    setText (text.substring (p1, text.length ()));
		else 
		    setText (text.substring (0, p0-1) 
			     + text.substring (p1, text.length ()));
		break; 
	    default: setText (text + ke.getKeyCode ());
	  }
	}
  }   
}
