package de.trantor.kcmd;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import de.kawt.*;
import de.kawt.shell.*;


public class KCmd extends Frame 
    implements ActionListener, FileListActivationListener {

    public static final int BUFSIZE = 512;

    FtpDialog ftpDialog = new FtpDialog (this);

    FileList left = new FileList (this);
    FileList right = new FileList (this);

    FileList active;
    FileList inactive;

    Panel buttons = new Panel ();
    ProgressBar progress = new ProgressBar (100);
    

    public KCmd (boolean network) {

	super (network ? "kFtp" : "kCmd");

	addButton ("open");
	addButton ("cp");
	addButton ("rm");
	addButton ("md");
	if (network) addButton ("ftp");
	
	Panel south = new Panel (new BorderLayout ());
	south.add ("West", buttons);

	//progress.setVisible (false);
	south.add ("Center", progress);

	addWindowListener (new Closer (this));

	Panel center = new Panel (new GridLayout (1, 2));
	
	center.add (left);
	center.add (right);

	add ("Center", center);
	add ("South", south);
	pack ();

	left.setActive (true);
    }
	    
    
    void addButton (String name) {
	Button button = new Button (name);
	buttons.add (button);
	button.setActionCommand (name);
	button.addActionListener (this);
    }


    public void actionPerformed (ActionEvent ev) {

	String cmd = ev.getActionCommand ();
	
	try {
	    if (cmd.equals ("ftp")) {
		if (active.getShell () instanceof FtpShell) {
		    active.getShell ().close ();
		    active.setShell (new DefaultShell ());
		}
		else 
		    ftpDialog.show ();
	    }
	    else if (cmd.equals ("open")) {
		String file = active.getSelectedFile ();
		if (file == null);
		else if (file.endsWith ("/"))
		    active.cd (file);
		else 
		    new ViewDialog 
			(this, active.getShell (), file);
	    }
	    else if (cmd.equals ("cp")) {
		
		String file = active.getSelectedFile ();
		if (file == null || file.endsWith ("/")) return;
		    
		InputStream is = active.getShell ().getInputStream (file);
		OutputStream os = inactive.getShell ().getOutputStream (file);
		
		byte [] buf = new byte [BUFSIZE]; 

		int i = 0;
		int sum = 0;

		progress.setMax ((int) active.getShell ().getTransferSize ());
		//progress.setVisible (true);

		while (true) {
		    int avail = 0;

		    while (avail < BUFSIZE) {
			int cnt = is.read (buf, avail, BUFSIZE-avail);
			if (cnt == -1) break;
			avail += cnt;
		    }

		    sum += avail;
		    progress.setValue (sum);
		    
		    if (avail == 0) break;
		    os.write (buf, 0, avail);
		}

		progress.setValue (0);
		is.close ();
		os.close ();

		inactive.getShell ().closeStream ();
		active.getShell ().closeStream ();

		inactive.cd (".");
	    }
	    else if (cmd.equals ("rm")) {
		active.getShell ().rm (active.getSelectedFile ());
		active.cd (".");
	    }
	    else if (cmd.equals ("md")) {
		String newdir = OptionDialog.showInputDialog 
		    (this, "Create Dir Name:");

		if (newdir != null) {
		    active.getShell ().mkdir (newdir);
		    active.cd (".");
		}
	    }
	}
	catch (IOException e) {
	    throw new RuntimeException ();
	}
    }

    public void fileListActivated (FileList l) {
	
	inactive = l == left ? right : left;
	inactive.setActive (false);
	active = l;
	//	active.setActive (true);
    }

    public void mouseReleased (MouseEvent e) {}

    public static void main (String [] argv) {
	new KCmd (false).show ();
    }
}

