package de.kawt;


import java.awt.*;
import java.awt.event.*;


public  class OptionDialog extends Dialog implements ActionListener{

    public static final int CLOSED_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int YES_OPTION = 2;
    public static final int NO_OPTION = 4;
    public static final int CANCEL_OPTION = 8;
    public static final int INPUT_OPTION = 16;
    

    TextField inputLine;
    Panel buttons = new Panel ();
    int pressed;


    /** The OptionDialog is similar to the swing class JOptionPane,
	except that it is derived from dialog directly.  However,
	several of the static showXXX methods of JOptionPane are also
	available here. */


    public OptionDialog (Component component, String message, String title, 
			 String deflt, int options) {
	
       	super (getFrame (component), title, true);

	add ("North", new Label (message));
	if ((options & INPUT_OPTION) != 0) {
	    inputLine = new TextField (deflt);
	    add ("Center", inputLine);
	}

	addButton (options, YES_OPTION, "yes");
	addButton (options, NO_OPTION, "no");
	addButton (options, OK_OPTION, "ok");
	addButton (options, CANCEL_OPTION, "cancel");

	add ("South", buttons);

        pack ();
	show ();
    }

    
    public static Frame getFrame (Component component) {

	while (component.getParent () != null)
	    component = component.getParent ();

	Window win = (Window) component;

	while (win.getOwner () != null) {
	    win = win.getOwner ();
	}

	return (Frame) win;
    }
    

    void addButton (int options, int code, String label) {
	if ((options & code) != 0) {
	    Button button = new Button (label);
	    buttons.add (button);
	    button.setActionCommand (""+code);
	    button.addActionListener (this);
	}
    } 
    

    public void actionPerformed (ActionEvent e) {
	
	pressed = Integer.parseInt (e.getActionCommand ());
	dispose ();
    }
    

    public static int showConfirmDialog (Component component, 
					 String msg, String title) {
	return showConfirmDialog 
	    (component, msg, title, YES_OPTION | NO_OPTION | CANCEL_OPTION);
    }
	    

    public static int showConfirmDialog (Component component, 
					 String msg, String title, 
					 int type) {

	return new OptionDialog (component, msg, title, null, type).pressed;
    }


    public static String showInputDialog (Component component, String msg) {
	OptionDialog od = new OptionDialog 
	    (component, msg, "Input", "", 
	     OK_OPTION | CANCEL_OPTION | INPUT_OPTION);

	return od.pressed == OK_OPTION ? od.inputLine.getText () : null;
    }


    public static void showMessageDialog (Component component, String msg) {
	OptionDialog od = new OptionDialog 
	    (component, msg, "Message", "", OK_OPTION);
    }
}
    
