package de.trantor.kcmd;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import de.kawt.*;
import de.kawt.shell.*;


class FtpDialog extends Dialog implements ActionListener {
	
    TextField server = new TextField ("ftp.leo.org");
    TextField user = new TextField ("anonymous");
    TextField password = new TextField ("abc@yahoo.com");
    
    Button ok = new Button ("ok");
    Button cancel = new Button ("cancel");
    
    KCmd kcmd;

    FtpDialog (KCmd kcmd) {
	super (kcmd, "open FTP");
	
	this.kcmd = kcmd;

	Panel left = new Panel (new GridLayout (0, 1));
	Panel right = new Panel (new GridLayout (0, 1));
	Panel buttons = new Panel ();
	
	left.add (new Label ("Server:", Label.RIGHT));
	left.add (new Label ("User:", Label.RIGHT));
	left.add (new Label ("Password:", Label.RIGHT));
	
	right.add (server);
	right.add (user);
	right.add (password);
	
	buttons.add (ok);
	ok.addActionListener (this);
	buttons.add (cancel);
	cancel.addActionListener (this);
	
	add ("West", left);
	add ("Center", right);
	add ("South", buttons);

	pack ();
    }
    
    
    public void actionPerformed (ActionEvent ae) {
	setVisible (false);
	
	if (ae.getSource () == ok) {
	    
	    try {
		FtpShell ftp = new FtpShell ();
		ftp.open (server.getText (), user.getText (), password.getText ());
		kcmd.active.setShell (ftp);
	    }
	    catch (IOException e) {
		OptionDialog.showMessageDialog (this, "Connection failed!");
	    }
	}		
    }
}

