/* Graphics.java 
 *
 * 2000-05-20 SH hitClip added
 * 2000-05-01 SH create from graphics bug fixed
 * 2000-04-09 SH Preparation for improved repaint: multiple clip rects 
 * 1999-11-07    Version number 0.11 released
 * 1999-10-22    Version number 0.1 released
 *
 * Copyright 1999,2000 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */

package java.awt;

import com.sun.kjava.*;
import java.util.Vector;

public class Graphics {

    static Graphics current;
    static Object lock = new Object ();
    static final Rectangle screenRect = new Rectangle (0, 0, 160, 160); 

    int originX;
    int originY;

    Color color = Color.black;
    boolean xorMode = false;
    Font font = Font.defaultFont;
    
    int nativeDrawMode = com.sun.kjava.Graphics.PLAIN;

    Rectangle [] clip;
    int clipCount;  

    public Graphics () {
	originX = 0;
	originY = 0;
	clipCount = 1;
	clip = new Rectangle [1];
	clip [0] = screenRect;
    }


    Graphics (Graphics g) {
	
	originX = g.originX;
	originY = g.originY;
	nativeDrawMode = g.nativeDrawMode;
	xorMode = g.xorMode;
	color = g.color;
	
	clipCount = g.clipCount;
	clip = new Rectangle [clipCount];
	System.arraycopy (g.clip, 0, clip, 0, clipCount);
    } 


    public Graphics create () {
	return new Graphics (this);
    }
    
    
    public Graphics create (int x, int y, int width, int height) {
	Graphics g = new Graphics (this);
	g.translate (x, y);
	g.clipRect (0, 0, width, height);
	return g;
    }
    

    public void checkContext (int i) {
	if (current != this || clipCount != 1) {
	    current = this;
	    Rectangle r = clip [i];
	    com.sun.kjava.Graphics.setDrawRegion 
		(r.x, r.y, r.width, r.height);
	}
    }
	

    public void clipRect (int x, int y, int w, int h) {
	current = null; // force setDrawRegion

	Rectangle r = new Rectangle (x + originX, y + originY, w, h);

	int dst = 0;

	for (int i = 0; i < clipCount; i++) {
	    Rectangle ir = clip[i].intersection (r);
	    if (ir.width > 0 && ir.height > 0) 
		clip [dst++] = ir;
	}
	clipCount = dst;
    }


    public void setClip (int x, int y, int w, int h) {
	current = null;
	clip [0] = new Rectangle (x + originX, y + originY, w, h);
	clipCount = 1;
    }
    
    
    public void clearRect (int x, int y, int w, int h) {
	synchronized (lock) {
	    for (int i = 0; i < clipCount; i++) {
		checkContext (i);
		com.sun.kjava.Graphics.drawRectangle 
		    (originX+x, originY+y, w, h, 
		     com.sun.kjava.Graphics.ERASE, 0);
	    }
	}
    }
    
    
    public void drawImage (Image image, int x, int y, 
			   Object observer) {
	
	synchronized (lock) {
	    for (int i = 0; i < clipCount; i++) { 
		checkContext (i);
		com.sun.kjava.Graphics.drawBitmap 
		    (x + originX, y+originY, image.bitmap);
	    }
	}
    }

    
    public void drawLine (int x1, int y1, int x2, int y2) {
	synchronized (lock) {
	    for (int i = 0; i < clipCount; i ++) { 
		checkContext (i);
		com.sun.kjava.Graphics.drawLine 
		    (x1+originX, y1+originY, 
		     x2+originX, y2+originY, nativeDrawMode);
	    }
	}
    }


    public void drawPolyline (int[] xPoints, int[] yPoints, 
			      int nPoints) {
	synchronized (lock) {
	    for (int j = 0; j < clipCount; j++) { 
		checkContext (j);

		for (int i = 0; i < nPoints - 1; i++) {
		    com.sun.kjava.Graphics.drawLine 
			(xPoints[i] + originX, 
			 yPoints[i] + originY, 
			 xPoints[i+1] + originX, 
			 yPoints[i+1] + originY, 
			 nativeDrawMode);
		}
	    }
	}
    }
    

    public void drawRoundRect (int x, int y, int width, int height, 
	               	         int arcWidth, int arcHeight) {
	
	int arc =  (arcWidth+arcHeight) / 2;
	
	if (arc > 0x0fff) arc = 0x0fff;
	
	synchronized (lock) {
	    for (int i = 0; i < clipCount;i ++) { 
		checkContext (i);
		com.sun.kjava.Graphics.drawBorder
		    (originX + x + 1, originY + y + 1, 
		     width - 2, height - 2, 
		     nativeDrawMode, arc << 8 | 1);
	    }
	}
    }


    public void drawString (String text, int x, int y) {
	synchronized (lock) {
	    for (int j = 0; j < clipCount; j++) { 
		checkContext (j);
		
		y += originY - 10;  // font pos = baseline in AWT!!!!
		x += originX;
		
		if (!font.isBold ())
		    com.sun.kjava.Graphics.drawString 
			(text, x, y, nativeDrawMode);
		else {
		    for (int i = 0; i < text.length (); i++) {
			String cc = ""+text.charAt (i);
			com.sun.kjava.Graphics.drawString 
			(cc, x++, y, nativeDrawMode);
			com.sun.kjava.Graphics.drawString 
			    (cc, x, y, nativeDrawMode);
			x += com.sun.kjava.Graphics.getWidth (cc);
		    }
		}
	    }
	}
    }


    public void drawOval (int x, int y, int w, int h) {
	int d = w;
	if (h < d) d = h;
	
	d += 2;
	
	drawRoundRect (x - 1, y -1, w+2, h+2, d, d);
    }
    


    public void drawRect (int x,  int y, int width, int height) {
	synchronized (lock) {
	    for (int i = 0; i < clipCount;i ++) { 
		checkContext (i);
		com.sun.kjava.Graphics.drawBorder
		    (originX + x + 1, originY + y+1, 
		     width - 2, height - 2, nativeDrawMode, 1);
	    }
	}
    }

    
    public void fillRect (int x, int y, int width, int height) {
	synchronized (lock) {
	    for (int i = 0; i < clipCount;i ++) { 
		checkContext (i);
		com.sun.kjava.Graphics.drawRectangle 
		    (originX + x, originY + y, 
		     width, height, nativeDrawMode, 0);
	    }
	}
    }
    
  
    public void fillRoundRect (int x, int y, 
			       int width, int height, 
			       int arcWidth, int arcHeight) {
	synchronized (lock) {
	    for (int i = 0; i < clipCount;i ++) { 
		checkContext (i);
		com.sun.kjava.Graphics.drawRectangle 
		    (originX + x, originY + y, 
		     width, height, nativeDrawMode, 
		     (arcWidth+arcHeight) >> 1);
	    }
	}
    }
    
    
    public Font getFont () {
	return font;
    }
    
    
    public synchronized boolean hitClip (int x, int y, int w, int h) {
      
	x += originX;
	y += originY;
	
	for (int i = 0; i < clipCount; i++) {
	    Rectangle r = clip [i];
	    if ((r.x <= x + w) && (r.x + r.width >= x) 
		&& (r.y <= y + h) && (r.y + r.height >= y))
		
		return true;
	}

	return false;
    }
    

    public FontMetrics getFontMetrics () {
	return new FontMetrics (font);
    } 


    public FontMetrics getFontMetrics (Font font) {
	return new FontMetrics (font);
    } 


    public void setColor (Color c) {
	color = c;
	if (!xorMode) {
	    int sum = ((c.rgb & 0x0ff0000) >> 16) 
		+ ((c.rgb & 0x0ff00) >> 8)
		+ (c.rgb & 0x0ff);
	    
	    if (sum > 256)
		if (sum > 512) nativeDrawMode = 
				   com.sun.kjava.Graphics.ERASE;

		else nativeDrawMode = com.sun.kjava.Graphics.GRAY;
	    else nativeDrawMode = com.sun.kjava.Graphics.PLAIN;
	}
    }
    

    public void setFont (Font font) {
	this.font = font;
    }
    

    public void setPaintMode () {
	xorMode = false;
	setColor (color);
    }


    public void setXORMode (Color c2) {
	xorMode = true;
	nativeDrawMode = com.sun.kjava.Graphics.INVERT;
    }
	

    public void translate (int x, int y) {
	originX += x;
	originY += y;
    }



    void _sub (Window w) {
	
	Rectangle [] iw 
	    = {new Rectangle (0, 0, 160, w.y),
	       new Rectangle (0, w.y+w.h, 160, 160),
	       new Rectangle (0, w.y, w.x, w.h),
	       new Rectangle (w.x + w.w, w.y, 160, w.h)};

	Vector newClip = new Vector ();

	for (int i = 0; i < clipCount; i++) {
	    Rectangle r = clip [i];
	    for (int j = 0; j < 4; j++) {
		Rectangle ir = r.intersection (iw [j]);
		if (ir.width > 0 && ir.height > 0) 
		    newClip.addElement (ir);
	    }
	}

	clipCount = newClip.size ();

	if (clipCount > clip.length) 
	    clip = new Rectangle [newClip.size ()];

	for (int i = 0; i < clipCount; i++) 
	    clip [i] = (Rectangle) newClip.elementAt (i);
    }
}


