/*
 * List.java 
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 *  2000-05-20 SH deselect added, setSelectedIndex renamed to select
 *  2000-05-02 SH deselction event bug fixed 
 *  2000-03-03 MK remove added
 *  2000-03-01 SH setSelectedIndex bug fixed
 *  2000-02-17 MK/SH ItemSelectable implemented
 *  1999-12-14 SH removed double paint problem 
 *  1999-11-30 Version 0.21:
 *             - getMinimumSize changed (wg. Choice out of screen)
 *             - repaint added to removeAll
 *  1999-11-26 Version 0.2;  
 *             - getSelectedIndex added (bugrep. by Flemming Bregnvig)
 *  1999-11-07 Version number 0.11 released
 *	       -flickering while itemselection fixed
 *	       -list srolls now while dragging out of
 *	       -the list area
 *  1999-10-22 Version number 0.1 released
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */


package java.awt;

import java.awt.event.*;
import java.util.Vector;

/** the List is currently only used as helper class for the choice since
 *  scrolling is not yet implemented
 */

public class List extends Component implements ItemSelectable {
    
    Vector elements = new Vector ();
    
    int sel = -1;
    int newSel = -1;
    int minW = 20;
    Choice choice;
    Scrollbar scrollbar;
    
    ItemListener il;
    
    public List () {
    }

    List (Choice choice) {
	this.choice = choice;
    }
    
    public void add (String item) {
	int iw = com.sun.kjava.Graphics.getWidth (item)+7;

	if (iw > minW) minW = iw;
	elements.addElement (item);
	repaint ();
    }

    
    public void addItemListener (ItemListener l) {
	if (il != null) 
	    throw new TooManyListenersException ();
	
	il = l;
    }

 
    public Dimension getMinimumSize () {
	int border = (choice == null) ? 2 : 6;
	
	int mh = elements.size () * Toolkit.defaultTextHeight + border;
	if (mh > 100) mh = 100;

	return new Dimension 
	    (minW + border, mh);
    }
    
    
    public int getSelectedIndex () {
	return sel;
    }

    public String getSelectedItem () {
	if (sel < 0 || sel >= elements.size ()) return null;
	return (String) elements.elementAt (sel);
    }

    public Object [] getSelectedObjects () {
	return new Object [] {elements.elementAt (sel)};
    }
    
    public void update (Graphics g) {
	paint (g);
    }
    
    public void paint (Graphics g) {
	
	if (choice != null) {
	    g.drawLine (2, 1, w-3, 1);
	    g.drawLine (2, h-2, w-2, h-2);
	    g.drawLine (3, h-1, w-3, h-1);

	    g.drawLine (1, 2, 1, h-3);
	    g.drawLine (w-2, 2, w-2, h-2);
	    g.drawLine (w-1, 3, w-1, h-3);
	}
	else 
	    g.drawRect (0,0,w,h);

	int border = (choice == null) ? 1 : 2;


	// care abt scrollbar pos and size here only!
	int visible = (h - 2 * border) / Toolkit.defaultTextHeight;

	if (visible < elements.size ()) {

	    boolean newsb = scrollbar == null;

 	    if (newsb) {
		scrollbar = new Scrollbar (); 
		scrollbar.internalOwner = this;
		scrollbar.setSize (scrollbar.getMinimumSize ());
	    }

	    scrollbar.maxValue = elements.size () - visible;
	    scrollbar.currVisible = visible;
	    scrollbar.blockIncrement = visible;

	    scrollbar.x = w - scrollbar.w-border;
	    scrollbar.y = border;
	    scrollbar.h = h - border-border;

	    g.originX += scrollbar.x;
	    g.originY += scrollbar.y;

	    if (newsb) 
		scrollbar.update (g);//.create (scrollbar.x, scrollbar.y, 
				//	   scrollbar.w, scrollbar.h));
	    else
		scrollbar.paint (g);//.create (scrollbar.x, scrollbar.y, 
				//	   scrollbar.w, scrollbar.h));
	    g.originX -= scrollbar.x - border;
	    g.originY -= scrollbar.y - border;
	    g.clipRect (0, 0, 
			w - scrollbar.w - border - border,
			h - border - border);
	    /*
	    g = g.create (border, border, 
			  w - scrollbar.w - border - border, 
			  h - border - border);
	    */
	    // create new graphics with new clipping here
	}
	else {
	    g = g.create (border, border, w - border*2, h - border*2);
	    scrollbar = null;
	}


	// draw list

	int i = (scrollbar == null) ? 0 : scrollbar.currValue;
	int ty = 0;
	
	while ( ty < h) {
	    // XXX change in Graphics (baseline!)
	    
	    g.setColor (Color.white);
	    g.fillRect (0, ty, w-border-border, Toolkit.defaultTextHeight);

	    if (i < elements.size ()) {
		g.setColor (Color.black);
		g.drawString (""+elements.elementAt (i), border, 
			      ty+Toolkit.defaultTextHeight-1); 
       
		if (i == newSel) {
		    g.setXORMode (Color.black);
		    g.fillRect (0, ty, w-border-border, 
				Toolkit.defaultTextHeight);
		    
		    g.setPaintMode ();
		}
	    }

	    i++;
	    ty += Toolkit.defaultTextHeight;
	}
    }


    public void processMouseEvent (MouseEvent me) {
	if (scrollbar != null && me.getX () > w - scrollbar.w - 2) {
	    me.translatePoint (- (w - scrollbar.w -2), -1);
	    scrollbar.processMouseEvent (me);
	    return;
	}

	if (me.getID () == me.MOUSE_RELEASED) 
	    select (newSel);

	if (me.getID () != me.MOUSE_DRAGGED 
	    && me.getID () != me.MOUSE_PRESSED) return;

	int newNewSel = ((scrollbar == null) ? 0 : scrollbar.currValue) 
	    + me.getY () / Toolkit.defaultTextHeight;

	if (newNewSel < 0) newNewSel = 0;
	if (newNewSel >= elements.size ()) newNewSel = elements.size () -1;
	
	else if (newNewSel != newSel) {
	    newSel = newNewSel;

	    if (scrollbar != null) {
		if (newSel < scrollbar.currValue) 
		    scrollbar.currValue = newSel;
		else if (newSel > scrollbar.currValue + scrollbar.currVisible) 
		    scrollbar.currValue = newSel - scrollbar.currVisible;
	    }
	    repaint ();
	}
    }


    public void removeAll () {
	elements.removeAllElements ();
	repaint ();
    }

    
    public void remove (int position) {
	elements.removeElementAt (position);
	repaint ();
    }

    
    public void removeItemListener (ItemListener l) {
	if (l == il) il = null;
    }

    public void deselect (int old) {

	if (old != sel || old == -1 || old >= elements.size ()) return;
	
	newSel = -1;
	sel = -1;

	il.itemStateChanged 
	    (new ItemEvent (this, 
			    ItemEvent.ITEM_STATE_CHANGED, 
			    elements.elementAt (old), 
			    ItemEvent.DESELECTED));

	repaint ();
    }
    

    public void select (int index) {

	ItemSelectable source = this;
	
	if (choice != null) { 
	    if (choice.win != null) choice.win.setVisible (false);
	    //	    choice.repaint ();
	    source = choice;
	}


	if (index != sel) {

	    int old = sel;

	    if (choice != null) {
		sel = index;
		choice.repaint ();
	    }
	    else {
		if (newSel == sel) // setzen von aussen  
		    repaint ();

		sel = index;
	    }
	    

	    newSel = sel;
        
	    if (il != null) {
		if (old != -1 && old < elements.size ())
		    il.itemStateChanged 
			(new ItemEvent (source, 
					ItemEvent.ITEM_STATE_CHANGED, 
					elements.elementAt (old), 
					ItemEvent.DESELECTED));

		il.itemStateChanged 
		    (new ItemEvent (source, 
				    ItemEvent.ITEM_STATE_CHANGED, 
				    elements.elementAt (index), 
				    ItemEvent.SELECTED));
	    } 
	} 
    }
}


