package java.awt;

import java.awt.event.*;

public class ScrollPane extends Container {
    
    Scrollbar vBar;
    Scrollbar hBar;
    
    int viewPortW;
    int viewPortH;

    Component remouse;
    Component child;

    public ScrollPane () {
	// remove the unneeded children vector to free some mem

	children = null;  
    }


    public Component add (String where, Component c) {
	child = c;
	c.parent = this;
	invalidate ();
	return c;
    }


    public void paintAll (Graphics g) {

	if (child == null || !visible) return;
	// draw scrollbars

	// change g according to scrollbars and insets
	
	if (vBar != null) {
	    vBar.paint (g.create (vBar.x, vBar.y, vBar.w, vBar.h));
	    child.y = -vBar.currValue;
	}
	else child.y = 0; // (viewPortH - child.h) / 2;

	if (hBar != null) { 
	    hBar.paint (g.create (hBar.x, hBar.y, hBar.w, hBar.h));
	    child.x = -hBar.currValue;
	}
	else child.x = 0; //(viewPortW - child.w) / 2;
	
	g.clipRect (0, 0, viewPortW, viewPortH);
	//	g.translate (xOff, yOff);

	//	System.out.println ("sbpa childx: "+child.x+ " y: "+child.y 
	//		    +" w: "+child.w + " h: "+child.h);

	Graphics g2 = g.create (child.x, child.y, child.w, child.h);

	child.paint (g2);
    }
    


    public synchronized void doLayout () {  

	viewPortW = w;
	viewPortH = h;

	if (child == null) return;

	Dimension d = child.getPreferredSize ();

	if (d.width < viewPortW) d.width = viewPortW;
	if (d.height < viewPortH) d.height = viewPortH;

	child.setSize (d);
	
	// two iterations!

	//	for (int i = 0; i <2; i++) {

	    if (child.h > viewPortH) {
		if (vBar == null) {
		    vBar = new Scrollbar (Scrollbar.VERTICAL);
		    vBar.internalOwner = this;
		    vBar.parent = this;
		    vBar.setSize (vBar.getMinimumSize ());
		}
		vBar.maxValue = child.h - h;
		vBar.currVisible = h;
		vBar.blockIncrement = h;
		vBar.unitIncrement = Toolkit.defaultTextHeight;
		
		vBar.x = w - vBar.w;
		vBar.y = 0;
		vBar.h = h;
		
		viewPortW = w - vBar.w;
	    }
	    else vBar = null;
	
	    if (child.w > viewPortW) {
		if (hBar == null) {
		    hBar = new Scrollbar (hBar.HORIZONTAL);
		    hBar.internalOwner = this;
		    hBar.parent = this;
		    hBar.setSize (hBar.getMinimumSize ());
		}
		hBar.maxValue = child.w - w;
		hBar.currVisible = w;
		hBar.blockIncrement = w;
		hBar.unitIncrement = Toolkit.defaultTextHeight;
	    
		hBar.y = h - hBar.h;
		hBar.x = 0;
		hBar.w = viewPortW;
		
		viewPortH = h - hBar.h;
		child.y = 0;
	    }
	    else hBar = null;
	    //	}

	child.doLayout ();
	valid = true;
    }

    
    public Component findComponentAt (int px, int py) {

	if ((!visible) || !contains (px, py)) return null;
	
	if (vBar != null) {
	    if (px > viewPortW) return vBar;
	    px += vBar.currValue;
	}
	
	if (hBar != null) {
	    if (py > viewPortH) return hBar;
	    py += hBar.currValue;
	}

	return child.findComponentAt (px, py);
    }
}
