package java.io;


public class FileInputStream extends InputStream {

    RandomAccessFile raf;


    public FileInputStream (File file) throws FileNotFoundException {
	raf = new RandomAccessFile (file, "r");
    }

    
    public void close () {
	raf.close ();
    }


    public int read (byte [] buf, int start, int len) throws IOException {
	return raf.read (buf, start, len);
    }


    public int read () throws IOException {
	
	return (raf.getFilePointer () < raf.length ()) 
	    ? (((int) raf.read ()) & 255)
	    : -1;
    }
    
    
}
