package java.io;

/** RandomAccessFile */


public class RandomAccessFile {

    static int openFiles;
    byte [] buf;

    ClusterTable clusterTable;

    int clusterPos;
    int fragmentPos;
    int pos;
    boolean dirty = false;
    
    /*   
    public void seek (int p){
	int go = p / CLUSTER_SIZE;
	int cur = position / CLUSTER_SIZE;
    }
    */

    

    public RandomAccessFile (String name, String mode) {

	this (new File (name), mode);
    }


    public RandomAccessFile (File file, String mode) {

	//	System.out.println ("filename: "+file.name);


	openFiles++;

	clusterTable = new ClusterTable 
	    (file, mode.equals ("d"));

	seek (0);
    }

    
    public void close () {
	flush ();

	buf = null;
	fragmentPos = 0;
	
	if (--openFiles == 0) {

	    ClusterTable.db.close ();
	    ClusterTable.db = null;
	}
    }


    public void flush () {
	if (dirty) {
	    clusterTable.writeCluster (clusterPos, buf);
	    clusterTable.flush ();
	}
    }


 
    
    public int getFilePointer () {
	return pos;
    }


    public int length () {
	return clusterTable.fileSize;
    }


    public byte read(){
	
	if (pos >= clusterTable.fileSize)
	    throw new RuntimeException ("READ PAST END"); 

	if (fragmentPos >= ClusterTable.CLUSTER_SIZE) 
	    seek (pos);

	pos++;
	return buf [fragmentPos++];
    }


    public int read (byte [] rbuf, int start, int len) {
	if (len == 0) return 0;

	if (fragmentPos >= ClusterTable.CLUSTER_SIZE) 
	    seek (pos);

	len = Math.min (len, ClusterTable.CLUSTER_SIZE - fragmentPos);
	len = Math.min (len, clusterTable.fileSize - pos);

	System.arraycopy (buf, fragmentPos, rbuf, start, len);

	pos += len;
	fragmentPos += len;

	return len == 0 ? -1 : len;
    }


    public void write (byte [] wbuf, int offset, int len) {

	if (pos + len > clusterTable.fileSize) 
	    clusterTable.setFileSize (pos + len);

	while (len > 0) {
	    if (fragmentPos >= ClusterTable.CLUSTER_SIZE) 
		seek (pos);

	    int cnt = Math.min 
		(len, ClusterTable.CLUSTER_SIZE - fragmentPos);

	    System.arraycopy (wbuf, offset, buf, fragmentPos, cnt);

	    dirty = true;
	    len -= cnt;
	    pos += cnt;
	    fragmentPos += cnt;
	    offset += cnt;
	}	
    }


    public String readLine () {
	
	StringBuffer sb = new StringBuffer ();

	while (true) {
	    if (pos >= clusterTable.fileSize) break;

	    byte b = read ();
	    if (b == 10) break;
	    
	    sb.append ((char) b);
	}
	
	return sb.toString ();
    }


    public void seek (int dest) {

	flush ();

	if (dest > clusterTable.fileSize) 
	    throw new RuntimeException ("seek past eof");

	clusterPos = dest >> ClusterTable.CLUSTER_SIZE_LD;
        fragmentPos = dest - clusterPos * ClusterTable.CLUSTER_SIZE;
	
	/*System.out.println ("seek-pos: "+pos+ " cl:"+clusterPos 
	  + " fp:"+fragmentPos); */

	pos = dest;

	if (pos == clusterTable.fileSize && fragmentPos == 0) 
	    buf = new byte [ClusterTable.CLUSTER_SIZE];
	else 
	    buf = clusterTable.readCluster (clusterPos);
    }


    public void setLength (int newLength) {
	if (newLength != clusterTable.fileSize) {
	    clusterTable.setFileSize (newLength);
	    dirty = true;
	}
    }

    
    public void write (byte b) {

	if (pos >= clusterTable.fileSize) 
	    clusterTable.setFileSize (pos+1);
	
	if (fragmentPos >= ClusterTable.CLUSTER_SIZE) 
	    seek (pos); 

	buf [fragmentPos++] = b;
	pos++;
	dirty = true;
    }

    
    public void writeLine (String line) {
	for (int i = 0; i < line.length (); i++) 
	    write ((byte) line.charAt (i));

	write ((byte) 10);
    }
}
