package de.kawt.shell;

import java.util.*;
import java.io.*;


public class DefaultShell extends AbstractShell {

    File path = new File (File.separator);
    
    public Vector ls () {
	File [] list = path.listFiles ();
	Vector result = new Vector ();

	result.addElement (new FileInfo ("..", FileInfo.DIRECTORY));

	for (int i = 0; i < list.length; i++) 
	    if (list [i].isDirectory ()) 
		result.addElement (new FileInfo (list [i]));

	for (int i = 0; i < list.length; i++) 
	    if (!list [i].isDirectory ()) 
		result.addElement (new FileInfo (list [i]));

	return result;
    }


    public boolean cd (String newDir) {
	File newpath = new File (path.toString (), newDir);
	
	if (newpath.isDirectory ()) {
	    path = newpath;
	    return true;
	}
	return false;
    }

    
    public void mkdir (String newDir) {
	new File (path.toString (), newDir).mkdir ();
    }


    public String pwd () {
	try {
	    return path.getCanonicalPath ();
	}
	catch (IOException e) {
	    throw new RuntimeException (e.toString ());
	}
    }


    public InputStream getInputStream (String localName) throws IOException {
	
	//System.out.println (path + "--"+localName);
	File f = new File (path, localName);

	transferSize = f.length ();
	return new FileInputStream (f);
    } 


    public OutputStream getOutputStream (String localName) throws IOException {
	
	return new FileOutputStream (new File (path, localName));
    }


    public void rm (String name) {
	new File (path, name).delete ();
    }
} 

