/*
 * SpotletWrapper.java
 *
 * History: 
 *  2000-05-22 SH Repaint bug fixed
 *  2000-05-19 SH KawtThread and repaint support added
 *  1999-10-22    Version number 0.1 released
 *  1999-11-07    Version number 0.11 released
 *  1999-11-24    Changes for 0.14 synchronized constants with original awt
 *
 * Copyright 1999,2000 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */


package java.awt;

import com.sun.kjava.Spotlet;
import java.awt.event.*;
import java.util.Vector;

class SpotletWrapper extends Spotlet {

    KawtThread kawtThread;
    Vector frames = new Vector ();   // contains visible frames only!
    static SpotletWrapper wrapper;

    Component mouseOwner;
    int mouseOrgX;
    int mouseOrgY;

    Vector repaint = new Vector ();
    Vector repaintRects = new Vector ();

    public SpotletWrapper () {
	register (NO_EVENT_OPTIONS);
	kawtThread = new KawtThread ();
	kawtThread.start ();
    }


    synchronized void addRepaint (Component c, Rectangle r) {
	
	if (!c.visible) return;

	int cnt = repaint.size ();

	for (int i = 0; i < cnt; i++) {

	    Component ci = (Component) repaint.elementAt (i);
	    Rectangle ri = (Rectangle) repaintRects.elementAt (i);
	    
	    if (c == ci) {
		ri.add (r);
		return;
	    }
	    if ((c instanceof Container) 
		&& ((Container) c).isAncestorOf (ci)) {
		
		do {
		    ri.x += ci.x;
		    ri.y += ci.y;
		    ci = ci.parent;
		} while (ci != c);
		
		r.add (ri);
		repaint.removeElementAt (i);
		repaintRects.removeElementAt (i);
		i--;
		cnt--;
	    }
	    else if ((ci instanceof Container)
		     && ((Container) ci).isAncestorOf (c)) {
		
		do {
		    r.x += c.x;
		    r.y += c.y;
		    c = c.parent;
		} while (c != ci);
		ri.add (r);    
		//		repaintRects.setElementAt 
		//    (new Rectangle (0, 0, ci.w, ci.h), i);

		return;
	    }
	}

	repaint.addElement (c);
	repaintRects.addElement (r);
    }
    
    public synchronized void flushRepaint () {
	
	int cnt = repaint.size ();

	for (int i = 0; i < cnt; i++) { 

	    Component c = (Component) repaint.elementAt (i);
	    Graphics g = c.getGraphics ();
	    if (g != null) {
		Rectangle r = (Rectangle) repaintRects.elementAt (i);
		g.clipRect (r.x, r.y, r.width, r.height);
		c.update (g);
	    }
	}

	repaint.removeAllElements ();// = new Vector ();
	repaintRects.removeAllElements ();// = new Vector ();
    }


    Frame getActiveFrame () {
	int i = frames.size ();
	return i > 0 ? (Frame) frames.elementAt (i-1) : null;
    }
    

    public void keyDown (int keyCode) {

	Frame frame = getActiveFrame ();
	
	if (frame == null) return;
	
	Window top = frame.getTopWindow ();
	
	if (top.focus == null) return;
	
	if (keyCode < 31 || keyCode > 128) { 
	    switch (keyCode) {
	    case 28: keyCode = KeyEvent.VK_LEFT; break;
	    case 29: keyCode = KeyEvent.VK_RIGHT; break;
	    case PAGEDOWN: keyCode = KeyEvent.VK_PAGE_DOWN; break;
	    case PAGEUP: keyCode = KeyEvent.VK_PAGE_UP; break;
	    }
		
	    kawtThread.processEvent 
		('k', top.focus, 
		 new KeyEvent (top,
			       KeyEvent.KEY_PRESSED, 0, 0,
			       keyCode, KeyEvent.CHAR_UNDEFINED));
	    
	}
	else
	    kawtThread.processEvent  
		('k', top.focus, 
		 new KeyEvent (top, 
			      KeyEvent.KEY_TYPED, 0, 0,
			      KeyEvent.VK_UNDEFINED, (char) keyCode));
    }	
    
    
    public void penDown (int x, int y) {

	Frame frame = getActiveFrame ();
	if (frame == null) return;

	Window topWindow = frame.getTopWindow ();
	Point p = topWindow.getLocationOnScreen ();
	
	mouseOwner = topWindow.findComponentAt (x - p.x, y - p.y);
	
	if (mouseOwner != null) {
	    p = mouseOwner.getLocationOnScreen ();
	    
	    mouseOrgX = p.x;
	    mouseOrgY = p.y;
	    
	    
	    kawtThread.processEvent 
		('m', mouseOwner,
		 new MouseEvent (mouseOwner, 
				 MouseEvent.MOUSE_PRESSED, 0, 0, 
				 x-mouseOrgX, y-mouseOrgY));
	}
	else if (topWindow.isMenu) 
	    topWindow.setVisible (false); 
    }
    
    
    public void penUp (int x, int y) {

	if (mouseOwner == null) return;

	x -= mouseOrgX;
	y -= mouseOrgY;

	kawtThread.processEvent 
	    ('m', mouseOwner,  
	     new MouseEvent (mouseOwner, 
			     MouseEvent.MOUSE_RELEASED, 0, 0, x, y));
	
	
	kawtThread.processEvent 
	    ('m', mouseOwner, 
	     new MouseEvent (mouseOwner, 
			     MouseEvent.MOUSE_CLICKED, 0, 0, x, y));
  }
    

    public void penMove (int x, int y) {
	if (mouseOwner != null) 
	    kawtThread.processEvent 
		('m', mouseOwner,
		 new MouseEvent (this, MouseEvent.MOUSE_DRAGGED, 0, 0, 
				 x-mouseOrgX, y-mouseOrgY));
    }
}


