package java.io;

/** File */


import java.util.*;


public class File {

    String givenName;
    
    boolean valid = false;

    File parent;
    String localName;
    int clusterTableRecord;
    boolean isDirectory;

    public static String separator = "/";
    public static char separatorChar = '/';


    File (int clusterTableRecord, File parent, 
	  String localName, boolean isDirectory) {

	givenName = concatNames (parent.givenName, localName);
	valid = true;

	this.clusterTableRecord = clusterTableRecord;
	this.parent = parent;
	this.localName = localName;
	this.isDirectory = isDirectory;
    }

    
    public File (File f, String s) {
	givenName = concatNames (f.toString (), s);
    }


    public File (String n1, String n2) {
	givenName = concatNames (n1, n2);
    }


    public File (String givenName) {
	this.givenName = givenName;
    }


    public boolean delete () {
	
	validate ();

	if (clusterTableRecord == -1 
	    || parent == null) {
	    System.out.println ("del "+localName + ": doesnt exist!");
	    return false; // doesnt exist
	}
	
	if (isDirectory && listFiles ().length != 0) {
	    System.out.println ("del "+localName + ": dir not empty!");
	    return false; // not empty
	}

	File [] parentFiles = parent.listFiles ();

	if (parentFiles == null) {
	    System.out.println ("del "+localName + ": parent file list null");
	    return false; // no parent dir (?!?)
	}

	RandomAccessFile parentFile = new RandomAccessFile (parent, "d");

	for (int i = 0; i < parentFiles.length; i++) {
	    File current = parentFiles [i];
	    if (!current.localName.equals (localName))
		parentFile.writeLine ((current.isDirectory ? "D" : "F") 
		    + current.clusterTableRecord + " " + current.localName);
	}

	System.out.println ("deleted, parent dir new length: "
			    +parentFile.getFilePointer ());
	
	parentFile.setLength (parentFile.getFilePointer ());
	parentFile.close ();

	new ClusterTable (this, true).delete ();

	clusterTableRecord = -1;

	return true;
    }

	
    void validate () {

	if (valid) return;

	if (givenName.equals ("/")) { 
	    clusterTableRecord = 0;
	    isDirectory = true;
	    localName = "/";
	}
	else {
	    if (givenName.endsWith ("/"))
		givenName = givenName.substring (0, givenName.length () - 1);

	    int cut = givenName.lastIndexOf ('/');
	    
	    if (cut < 1) parent = new File ("/");
	    else parent = new File (givenName.substring (0, cut));

	    parent.validate ();

	    localName = givenName.substring (cut+1);

	    if (localName.equals (".") || localName.equals ("..")) {
		
		File src = (localName.equals ("..") && parent.parent != null)
		    ? parent.parent
		    : parent;

		parent = src.parent;
		localName = src.localName;
		isDirectory = src.isDirectory;
		clusterTableRecord = src.clusterTableRecord;
		valid = src.valid;
	    }
	    else {
		clusterTableRecord = -1;

		File [] files = parent.listFiles ();
	    
		for (int i = 0; i < files.length; i++) {
		    if (files [i].localName.equals (localName)) { 
			isDirectory = files [i].isDirectory;
			clusterTableRecord = files [i].clusterTableRecord;
			parent = files [i].parent;
			break;
		    }
		}
	    }
	}
	
	valid = true;
    }


    static String concatNames (String s1, String s2) {
	if (!s1.endsWith ("/")) s1 = s1 + "/";

	if (s2.startsWith ("/")) s2 = s2.substring (1);

	return s1 + s2;
    }


    public String getCanonicalPath () throws IOException {
	validate ();

	if (parent == null) return "/";

	return concatNames (parent.getCanonicalPath (), localName);
    }


    public String getName () {
	return localName;
    }

    
    public boolean isDirectory () {
   
	validate ();
	return isDirectory;
    }
  
    public String [] list () {
	validate ();

	if (clusterTableRecord == -1) return null;

	RandomAccessFile file = new RandomAccessFile (this, "rw");
	Vector dir = new Vector ();

	System.out.println ("list - file length: "+file.length ());

	while (file.getFilePointer () < file.length ()) {
		
	    String entry = file.readLine ();
	    System.out.println ("list-entry: "+entry);
	    int cut = entry.indexOf (' '); 
	    dir.addElement (entry.substring (cut+1));
	}

	file.close ();
	String [] result = new String [dir.size ()];

	for (int i = 0; i < result.length; i++) 
	    result [i] = (String) dir.elementAt (i);

	return result;
    }

    public long length () {
	validate ();
	if (clusterTableRecord == -1) return 0;
	    
	return new ClusterTable (this, isDirectory).fileSize;
    }


    public File [] listFiles () {
	validate ();

	if (clusterTableRecord == -1) return null;
	
	RandomAccessFile file = new RandomAccessFile (this, "d");
	Vector dir = new Vector ();

	while (file.getFilePointer () < file.length ()) {
	    String entry = file.readLine ();
	    int cut = entry.indexOf (' ');
	    
	    dir.addElement (new File 
		(Integer.parseInt (entry.substring (1, cut)),
		 this,
		 entry.substring (cut+1),
		 entry.charAt (0) == 'D'));
	}

	file.close ();
	File [] result = new File [dir.size ()];

	for (int i = 0; i < result.length; i++) 
	    result [i] = (File) dir.elementAt (i);

	return result;
	
    }


    public boolean mkdir () {
	validate ();

	if (clusterTableRecord != -1) return false;
	RandomAccessFile file = new RandomAccessFile (this, "d");
	file.close ();
	return true;
    }

    
    public String toString () {
	try {
	    return getCanonicalPath ();
	}
	catch (IOException e) {
	    throw new RuntimeException ("ioerr:"+e);
	}
    } 
}

