package java.net;

import java.io.*;
import javax.microedition.io.*;

public class Socket {
    
    private String remoteHost = null;
    private int remotePort = 0;
    private StreamConnection socket = null;
    
    public Socket (String host, int port) throws IOException {
	String target = "socket://" + host + ":" + String.valueOf (port);
	socket = (StreamConnection) Connector.open (target, Connector.READ_WRITE, true);
    }
    
    public InputStream getInputStream () throws IOException {
	return socket != null ? socket.openInputStream (): null;  
    }
    
    public OutputStream getOutputStream () throws IOException {
	return socket != null ? socket.openOutputStream (): null;  
    }
    
    public int getPort () {
	return remotePort;
    }
    
    public void close () throws IOException {
	socket.close ();
    }
}

