// Authors: Stefan Haustein (SH), Michael Kroll (MK)
// 2000-05-20 SH Changed to modal dialog
// 1999-08-19 SH initial release
// 1999-08-29 SH added TestDialog
// 1999-09-02 MK added TabbedPane
// 1999-11-07 MK version 0.11 released
// 1999-11-22 MK version 0.12 released
// 1999-11-28 MK version 0.2 released
// 1999-12-05 MK version 0.21 released
// 1999-12-15 MK version 0.22 released
// 2000-02-17 MK version 0.23 released
// 2000-03-04 MK version 0.24 released
// 2000-03-06 MK version 0.25 released
// 2000-05-22 MK version 0.60 released
//               TestDialog Removed
// 2000-06-01 MK version 0.61 released
//               Closer removed

import java.awt.*;
import java.awt.event.*;
import de.kawt.*;

class LayoutPanel extends Panel implements ActionListener {
    
    LayoutManager saveBorder;
    Frame frame;
    
    LayoutPanel (Frame frame) {
	
	super (new BorderLayout ());
	this.frame = frame;
	addButton ("North", "grid");
	addButton ("South", "border");
	addButton ("East", "flow");
	addButton ("West", "exit");
	addButton ("Center", "dialog");
	saveBorder = getLayout ();
	validate ();
    }

    void addButton (String where, String label) {
	Button b = new Button (label);
	add (where, b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("grid")) 
	    setLayout (new GridLayout (3, 2));
	else if (cmd.equals ("flow"))
	    setLayout (new FlowLayout ());
	else if (cmd.equals ("border"))
	    setLayout (saveBorder);
	else if (cmd.equals ("dialog")) {
	    if (OptionDialog.showConfirmDialog 
		(frame, "Do you like kAWT?", "Sample Dialog") 
		== OptionDialog.NO_OPTION)
		OptionDialog.showInputDialog 
		    (frame, "Why do you use it then?");
	}
	else if (cmd.equals ("exit")) 
	    System.exit (0);
	validate ();
    }
}

class MemPanel extends Canvas {

    public void paint (Graphics g) {

	Dimension d = getSize ();

	int m = d.width > d.height ? d.height : d.width;
	int step = m / 10; 

	g.setColor (new Color (127, 127, 127));
	g.fillRect (0, 0, d.width, d.height);

	g.setColor (Color.white);

	for (int i = step/2; i < d.width; i+= step)
	    g.drawLine (i, 0, i, d.height);

	for (int i = step/2; i < d.height; i+= step)
	    g.drawLine (0, i, d.width, i);

	g.translate ((d.width - m) / 2, (d.height - m) / 2);
	g.fillRect (step, step, 8*step, 8*step); 

	for (int i = 0; i < 8; i++) {
	    g.setColor (new Color (((i & 1) * 255) ,
				 ((i & 2) >> 1) * 255 ,
				 ((i & 4) >> 2) *255));

	    g.fillRect ((i+1) * step, step, step, 2*step+step/2);
	    
	    int gray = 255 / 8 * i;
	    g.setColor (new Color (gray, gray, gray));

	    g.fillRect ((i+1) * step, 3*step+step/2, step, step+step/2);

	}
	    
	g.setColor (Color.white);
	g.drawOval (0, 0, m, m);

	int ty = 6*step;

	g.setColor (Color.black);

	g.drawString ("total mem: "+ Runtime.getRuntime().totalMemory(), 2*step, ty);
	g.drawString ("free mem: "+Runtime.getRuntime().freeMemory (), 2*step, ty+step);
	Runtime.getRuntime().gc();
	g.drawString ("post gc: "+Runtime.getRuntime ().freeMemory (), 2*step, ty+2*step);
    }
}


class MiscPanel extends Panel implements ActionListener, ItemListener { 
    Frame frame;
    MiscPanel (Frame frame) {
	super (new GridLayout (0, 1));
	this.frame = frame;
	CheckboxGroup group = new CheckboxGroup ();
	add (new Checkbox ("RadioButton 1", group, false)); 
	add (new Checkbox ("RadioButton 2", group, false));
	Checkbox titlebox = new Checkbox ("Show Frame Title", true);
	titlebox.addItemListener (this);
	add (titlebox);
	add (new TextField ("Test"));
	Choice choice = new Choice ();
	choice.add ("red");
	choice.add ("green");
	choice.add ("blue");
	add (choice);
	addButton ("beep");
	addButton ("exit");
    }
    
    void addButton (String label) {
	Button b = new Button (label);
	add (b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
    
    public void itemStateChanged (ItemEvent ev) {
 	if (ev.getStateChange () == ev.SELECTED) 
	    frame.setTitle ("kAWT Sample v0.61");
	else 
	    frame.setTitle (null);
	frame.validate ();
    }
    
    public void actionPerformed (ActionEvent ev) {
	if (ev.getActionCommand ().equals ("beep")) {
	    Toolkit.getDefaultToolkit ().beep ();
	}
	else System.exit (0);
  }
}

class ScrollbarPanel extends Panel implements AdjustmentListener, ActionListener {
    Label label;
    Scrollbar horizontal;

    ScrollbarPanel (Frame frame) {
	super (new BorderLayout ());
	Button exitB = new Button ("exit");
	exitB.addActionListener (this);
	exitB.setActionCommand ("exit");
	add ("West", exitB);

	label = new Label ();
	horizontal = new Scrollbar (Scrollbar.HORIZONTAL);
	horizontal.addAdjustmentListener (this);
      
	java.awt.List list = new java.awt.List ();
	for (int i= 0; i < 20; i++)	
	    list.add ("item "+i);
	
	add ("North", label);
	add ("Center", list);
	add ("South", horizontal);
	adjustmentValueChanged (null);

	validate ();
    }
    
    public void adjustmentValueChanged (AdjustmentEvent ev) {
	label.setText ("Pos h: "+horizontal.getValue ());
    }
    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("exit")) 
	    System.exit (0);
    }
}

public class KawtSample extends Frame {
    Dialog dialog;
    TabbedPane tabPane;

    KawtSample () {
	setTitle ("kAWT Sample v0.61");

	tabPane = new TabbedPane();
	tabPane.addTab ("Layout", new LayoutPanel (this));
	tabPane.addTab ("Misc", new MiscPanel (this));
	tabPane.addTab ("Scroll", new ScrollbarPanel (this));
	tabPane.addTab ("Color", new MemPanel ());
	add ("Center", tabPane);
	
	addWindowListener (new Closer (null));
	pack ();
    }
    
    public static void main (String [] argv) {
	new KawtSample ().show ();
    }
}






