package de.kawt.shell;

import java.net.*;
import java.io.*;
import java.util.*;

public class FtpShell extends AbstractShell {
    
    Socket controlConnection;
    InputStream controlInputStream;
    OutputStream controlOutputStream;

    Socket dataConnection;
    InputStream dataInputStream;
    OutputStream dataOutputStream;

    String host;
    String user;
    String pass;
    String path = "/";
    Vector currentDir;


    String exec (String in) throws IOException {
	//	leftList.add (in);
  
	for (int i=0; i < in.length (); i++) 
	    controlOutputStream.write ((byte) in.charAt (i));

	controlOutputStream.write (13);
	controlOutputStream.write (10);

	return readControlLine ();
    }


    public boolean cd (String path) {
	try {
	    exec ("cwd "+path);
	    currentDir = null;
	    return true;
	}
	catch (IOException e) {
	    return false;
	}
    }
    

    public Vector ls () {

	try {
	    Vector currentDir = new Vector ();

	    pasv (false);
	    exec ("list");
	
	    StringBuffer s = new StringBuffer ();
	    
	    boolean ignore = true;
	    
	    while (true) {
		int i = dataInputStream.read ();
		if (i == -1) break;
		if (i == 13) {
		    if (ignore) ignore = false;
		    else {
			String line = s.toString ();
			
			//		    System.out.println (line);
			
			int cut = line.lastIndexOf (' ');
			
			currentDir.addElement 
			    (new FileInfo (line.substring (cut+1), 
					   line.charAt (0) == 'd' 
					   ? FileInfo.DIRECTORY 
					   : 0));
		    }
		    s = new StringBuffer ();
		}
		else if (i > 31) s.append ((char) i);
	    }
	    
	    closeStream ();
	    
	    return currentDir;
	}
	catch (IOException e) {
	    return null;
	}
    }

    
    public void closeStream () throws IOException {
	dataInputStream.close ();
	dataOutputStream.close ();
	dataConnection.close ();
	readControlLine ();
    }


    public void close () {
	try {
	    controlInputStream.close ();
	    controlOutputStream.close ();
	    controlConnection.close ();
	}
	catch (IOException e) {
	    throw new RuntimeException (e.toString ());
	}
    }

    public void open (String host, String user, String pass) 
	throws IOException {

	this.host = host;
	this.user = user;
	this.pass = pass;

	controlConnection = new Socket (host, 21);
	controlInputStream = controlConnection.getInputStream ();
	controlOutputStream = controlConnection.getOutputStream ();
	
	readControlLine ();
	
	exec ("user "+user);
	exec ("pass "+pass);
    }


    void pasv (boolean binary) throws IOException {
	exec (binary ? "type i" : "type a");
	String passive = exec ("pasv");

	passive = passive.substring 
	    (passive.indexOf ('(')+1, 
	     passive.indexOf (')'));
	
	passive = passive.replace (',', '.');

	int cut = passive.lastIndexOf ('.');
		
	int port = Integer.parseInt (passive.substring (cut+1));
		
	passive = passive.substring (0, cut);

	cut = passive.lastIndexOf ('.');

	port = port + 256*Integer.parseInt (passive.substring (cut+1));
		
	passive = passive.substring (0, cut);

	//	leftList.add (passive+':'+port);

	dataConnection = new Socket (passive, port);
	dataInputStream = dataConnection.getInputStream ();
	dataOutputStream = dataConnection.getOutputStream ();
    }


    public String pwd () {
	return path;
    }


    public InputStream getInputStream (String name) throws IOException {
	pasv (true);
	String ret = exec ("retr "+name);
	int i0 = ret.indexOf ('(');
	int i1 = ret.indexOf (' ', i0);

	transferSize = Integer.parseInt (ret.substring (i0+1, i1)); 

	return dataInputStream;
    }


    public OutputStream getOutputStream (String name) throws IOException {
	pasv (true);
	String ret = exec ("stor "+name);

	//transferSize = Integer.parseInt (ret.substring (i0+1, i1)); 

	return dataOutputStream;
    }


    public void mkdir (String name) {
	try {
	    exec ("mkd "+name);
	}
	catch (IOException e) {}
    }


    public void rm (String name) {
	try {
	    exec ("dele "+name);
	    exec ("rmd "+name);
	}
	catch (IOException e) {}
    }


    String readControlLine () throws IOException {
	StringBuffer s;
	
	do {
	    s = new StringBuffer ();

	    while (true) {
		int i = controlInputStream.read ();
		if (i == -1 || i == 13) break;
		if (i > 31) s.append ((char) i);
	    }
	}
	while (s.length () < 4 || s.charAt (3) == '-');

	//	leftList.add (s.toString ());
	
	return s.toString ();
    }
}
