package java.awt;

import java.awt.event.*;
import de.kawt.*;
import de.kawt.shell.*;

public class FileDialog extends Dialog implements ActionListener {

    public static final int LOAD = 0;
    public static final int SAVE = 1;

    int mode;
    FileList fileList;
    TextField textField = new TextField ();

    String directory;
    String file;


    public FileDialog (Frame frame) {
	this (frame, null, LOAD);
    }

    public FileDialog (Frame frame, String title) {
	this (frame, title, LOAD);
    }

    public FileDialog (Frame frame, String title, int mode) {

	super (frame, title == null ? "Select File" : title, true);
	
	this.mode = mode;

	fileList = new FileList (null);
	fileList.setActive (true);
	
	add ("Center", fileList);

	Panel south = new Panel (new BorderLayout ());
	south.add ("West", new Label ("File:"));
	south.add ("Center", textField);

	Panel buttons = new Panel ();

	Button open = new Button (mode == LOAD ? "Open" : "Save");
	open.addActionListener (this);
	buttons.add (open);

	Button cancel = new Button ("Cancel");
	cancel.addActionListener (this);
	buttons.add (cancel);
	
	south.add ("East", buttons);

	add ("South", south);
	pack ();
    }


    public void actionPerformed (ActionEvent e) {
	if (!e.getActionCommand ().equals ("Cancel")) {

	    file = textField.getText ();
	    if (file == null || file.equals ("")) {
		file = fileList.getSelectedFile ();
		if (file.endsWith ("/")) {
		    fileList.cd (file);
		    //fileList.getShell ().cd (file);
		    file = null;
		    return;
		}
	    }
	    directory = fileList.getShell ().pwd ();
	}
	setVisible (false);
    }


    public String getFile () {
	return file;
    }


    public String getDirectory () {
	return directory;
    }
}
    
