package java.awt;

import java.io.*;


public class GifLoader  {

    int globalWidth;
    int globalHeight;
    int colorResolution;
    int globalPixelBits;
    int background;
    byte [] globalColorMap;
    InputStream is;

    static final int [] interlaceMap 
	= { 0,  8,  4, 12,  2,  6, 10, 
	    1,  3,  5,  7,  9, 11};
    
    int top;
    int left;
    int width;
    int height;
    int bufPos;
    //int bitPos;
    int resetCode;
    int endCode;

    int pixelBits;
    int colors;
    byte [] colorMap;
    byte [] buf;
    byte [] writeBuf;
    int writePos;
    
    int blockSize;
    int row;

    short [] prev;
    byte [] entry;

    //    int destinationDepth = Toolkit.defaultToolkit ().getColorModel.;// = System.getProper;

    int codeSize;
    int tableSize;
    int tableLimit;
    int x;
    int y;
    
    boolean interlaced;

    Image image;

    int current;
    int filled;
    int mask;

    public GifLoader (InputStream is) {
	this.is = is;
    }

    public Image load () throws IOException {


	buf = new byte [256];

	readBytes (buf, 6);
	
	//System.out.println ("Signature: "+new String (buf));
	
	width = readWord ();
	height = readWord (); 
	
	//System.out.println ("width: "+width + " height: "+height);

	int misc = is.read ();

	colorResolution = ((misc >> 4) & 7) + 1;
	globalPixelBits = (misc & 7)  + 1;
	background = is.read ();

	//System.out.println ("cr: "+colorResolution 
	//		    + " pixelBitsGlobal: "+ globalPixelBits
	//		    + " bg: " + background);

       	if (is.read () != 0) 
	    //throw new RuntimeException ("GIF Format error: 0 expected")
	    ;

	if ((misc & 128) != 0) {
	    //System.out.println ("Reading global color map");
	    globalColorMap = new byte [(1 << globalPixelBits)]; 
	    readColorMap (globalColorMap, globalColorMap.length);
	}
	//else System.out.println ("no global color map");

	image = new Image (width, height, Toolkit.pixelBits);
	writeBuf = new byte [width];

	while (true) {
	    int st = is.read ();
	    switch (st) {
	    case ',': readImage (); break;
	    case '!': readExtension (); break;
	    case -1:
	    case 0:
	    case ';': return image;
	    default: throw new RuntimeException ("bst#"+st);
	    }
	}
    }

    void readExtension ()  throws IOException{
	is.read (); // extension code
	while (true) {
	    int cnt = is.read ();
	    if (cnt <= 0) break;

	    readBytes (buf, cnt);
	}
    }
    
    
    void readBytes (byte [] buf, int count) throws IOException {

	int pos = 0;
	do {
	    int ok = is.read (buf, pos, count-pos);
	    if (ok == -1 || ok == 0) break;
	    pos += ok;
	}
	while (pos < count);

	if (count != pos) 
	    throw new RuntimeException ("Read past eof!");
    }  

    int readWord () throws IOException {
	int b = is.read ();
	return b | (is.read () << 8);
    }

    void readImage () throws IOException {
	
	left = readWord ();
	top = readWord ();
	width = readWord ();
	height = readWord ();
	
	row = 0;

	int misc = is.read (); 
	
        interlaced = (misc & 64) != 0;
	
	//System.out.println ("left: "+left + " top: "+top
	//		    + " width: "+width + " height: "+height
	//		    + " interlaced: "+interlaced);

	pixelBits = globalPixelBits;
	if ((misc & 128) != 0) {
	    pixelBits = (misc & 7) + 1;
	    // System.out.println ("Reading local color map");
	    colorMap = new byte [ 1 << pixelBits ];
	    readColorMap (colorMap, colorMap.length);
	}
	else {
	    // System.out.println ("no local color map");
	    colorMap = globalColorMap;
	}

	writePos = 0;
	
	int initialCodeSize = is.read () + 1;

	
	//System.out.println ("initialCodeSize: "+initialCodeSize);

	colors = 1 << pixelBits;
	//System.out.println ("colors: "+colors);
	
	blockSize = 0;

	codeSize = initialCodeSize;
	mask = (1 << codeSize) - 1;

	bufPos = 0;
	//bitPos = 0;
	
	//[1] Initialize string table;
	
	resetCode = 1 << (codeSize-1);
	endCode = resetCode + 1;
	tableSize = resetCode + 2;
	tableLimit = resetCode << 1;
	
	//System.out.println ("tabSize: "+tableSize);
	
	prev = new short [tableLimit - resetCode - 2];
	entry = new byte [tableLimit - resetCode - 2];
	
	//[2] get first code: <code>;

	int code = readCode ();
	
	while (code == resetCode) 
	    code = readCode ();
	
	// [3] output the string for <code> to the charstream;
	
	int k = writeTranslation (code);
	
	// [4] <old> = <code>;
	
	while (true) {
	    int old = code;
	    
	    // [5] <code> <- next code in codestream;
	    
	    code = readCode ();
	    
	    while (code == resetCode) {     
		codeSize = initialCodeSize;
		tableSize = resetCode + 2;
		tableLimit = resetCode << 1;
		mask = (1 << codeSize) - 1; 
		code = readCode ();
	    }
	    
	    if (code == endCode) break;
	    // check special conditions:
	    
	    // [6] does <code> exist in the string table?
	    
	    if (code < tableSize) {
		//  (yes: output the string for <code> to the charstream;
		
		// [...] <- translation for <old>;
		// K <- first character of translation for <code>;
		
		k = writeTranslation (code);
		
		// add [...]K to the string table;        
		addTable (old, k);
		
		// <old> <- <code>;  )
		
	    }
	    else {
		// (now: [...] <- translation for <old>;
		// K <- first character of [...];
		// output [...]K to charstream and add it to string table;
		addTable (old, k);
	
		writeTranslation (tableSize-1);
		// <old> <- <code>
	    }
	    
	    // [7] go to [5];
	}
    }


    void addTable (int base, int add) {

	if (tableSize + 1 == tableLimit) {
	    //System.out.println ("codesize inc (old): "+codeSize+ " tabsz: "+tableSize);

	    tableLimit *= 2;

	    if (prev.length + resetCode + 2 < tableLimit) {
		short [] newPrev = new short [tableLimit - resetCode - 2];
		System.arraycopy (prev, 0, newPrev, 0, prev.length);
		prev = newPrev;

		byte [] newEntry = new byte [tableLimit - resetCode - 2];
		System.arraycopy (entry, 0, newEntry, 0, entry.length);
		entry = newEntry;
	    }

	    codeSize ++;
	    mask = (1 << codeSize) - 1;
	}

	prev [tableSize - resetCode - 2] = (short) base;
	entry [tableSize - resetCode - 2] = (byte) add;
	tableSize ++;
    }

    void readColorMap (byte [] map, int len) throws IOException {
	for (int i = 0; i < len; i++) {
	    int r = 255-is.read ();
	    int g = 255-is.read ();
	    int b = 255-is.read ();
	    
	    if (Toolkit.pixelBits < 8) {
		map [i] = (byte) (((r + g + b) / 3) 
				  >> (8-Toolkit.pixelBits));
	    }
	    else {
		r /= 43;
		g /= 43;
		b /= 43;
		map [i] = (byte) (g 
				  + (6 * (b % 3))
				  + r * 3 * 6
				  + (b / 3) * 3 * 6 * 6);
	    }
	}
    }


    boolean exists (int code) {
	return (code < tableSize);
    }

    
    int writeTranslation (int code) {
	int result;
	byte write;
	
	if (code < colors) {
	    write = (byte) code;
	    result = code;
	}
	else if (code >= tableSize || code <= endCode) 
	    throw new RuntimeException ("illegal code: "+code);
	else {
	    code = code - resetCode - 2;

	    result = writeTranslation (prev [code]);
	    write = entry [code];
	}

	writeBuf [writePos] = colorMap [((int) write) & 0x0ff];
	if (++writePos >= width) {
	    /* 
	    for (int i = 0; i < width; i++) 
		System.out.print ((char) (writeBuf [i]+65));
		System.out.println ();*/
	    
	    int dy = top + (interlaced && row + 13 <= height 
			    ? (13 * (row / 13)) + interlaceMap [row % 13]
			    : row);
	    
	    image.setPixels (left, dy, width, 1, null, writeBuf, 0, width); 
	    writePos = 0;
	    row++;
	}

	return result;
    }


    int readCode () throws IOException {

	current = current >> codeSize;

	while (filled < codeSize) {
	    
	    if (bufPos >= blockSize) {
		blockSize = is.read (); 
		readBytes (buf, blockSize);
		bufPos = 0;
		//		bitPos = 0;
	    }	
	    
	    current |= (((int) buf [bufPos++]) & 255) << filled;
	    filled += 8;
	}

	filled -= codeSize;
	return current & mask;
	
	
	/*
	for (int i = 0; i <= codeSize; i++)
	    result +=  readBit () << i;

	    //System.out.println ("readcode: "+result); 

	return result;
	*/
    }

    /*
    int readBit () throws IOException {


	int result = ((buf [bufPos]) >> bitPos) & 1;

	//System.out.println ("readBit ("+bufPos+":"+bitPos+") ="+result);
	
	bitPos++;
	if (bitPos == 8) {
	    bitPos = 0;
	    bufPos++;
	}

	return result;
    }
    */    

    void writeByte (int b) {

    }

    

    public static void main (String [] argv) throws IOException {

	new GifLoader (new FileInputStream (new File (argv [0]))).load ();

    }

}

