/*
 * Choice.java Version 0.23 2000-02-17
 *
 * History: 2000-02-17 ItemSelectable interface implemented etc.
 *          1999-10-22 Version number 0.1 released
 *	    1999-11-07 Version number 0.11 released
 *		       - paint error removed
 *
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */


package java.awt;

import java.awt.event.*;

public class Choice extends Component implements ItemSelectable {
    
    List list = new List ();
    Window win;

    public Choice () {
	list = new List (this);
	list.sel = 0;
    }
    
    public void add (String item) {
	list.add (item);
    }
    
    public void addItem (String item) {
	add (item);
    }
    
    public void addItemListener (ItemListener l) {
	list.addItemListener (l);
    }
    
    public String getItem (int index) {
	return (String) list.elements.elementAt (index);
    }
    
    public int getItemCount () {
	return list.elements.size ();
    }

    public int getSelectedIndex () {
	return list.sel;
    }
    
    public String getSelectedItem () {
	return (String) list.elements.elementAt (list.sel);
    }
    
    public Object [] getSelectedObjects () {
	return new Object [] {list.elements.elementAt (list.sel)};
    }


    public Dimension getMinimumSize () {
	Dimension ms = list.getMinimumSize ();
	ms.height = 11;
	return ms;
    }
    
    /*
      public void insert (String item, int index) {
      list.elements.add (index, item);
      }
    */
    
    public void processMouseEvent (MouseEvent ev) {
	if (ev.getID () != ev.MOUSE_CLICKED) return;
	
	if (win == null) { 
	    win = new Window (_getWindow ().owner);
	    
	    win.isMenu = true;
	    win.add ("Center", list);
	    win.pack ();
	}
	
	Point p = getLocationOnScreen ();
	
	Dimension scr = Toolkit.getDefaultToolkit ().getScreenSize ();
	
	win.x = p.x;
	win.y = p.y + (h - win.h) / 2;
	
	if (win.x + win.w > scr.width) 
	    win.x = scr.width - win.w;
	if (win.y + win.h > scr.height) 
	    win.y = scr.height - win.h;
	if (win.y < 0) win.y = 0;
	if (win.x < 0) win.x = 0;

	win.show ();	
    }
    
    public void paint (Graphics g) {

	g.drawImage (Scrollbar.imgDown, 1, h/2-3, this);
	String sel = "" + list.getSelectedItem ();
	g.drawString (sel, 12, h / 2 + 5);
    }
    
    public void remove (String item) {
	list.elements.removeElement (item);
    }
    
    public void remove (int index) {
	list.elements.removeElementAt (index);
    }
    
   
    public void removeItemListener (ItemListener l) {
	list.removeItemListener (l);
    }
    
    public void select (int index) {
	list.select (index);
    }
    
    public void select (String item) {
	select (list.elements.indexOf (item));
    }
}




