/*
 * Image.java Version 0.11 99/11/07 
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */


package java.awt;

/** currently, only wrapper for palm image with hidden constructor
 *  for kAWT internal usage only.
 *
 */  

import java.awt.image.*;
import com.sun.kjava.Bitmap;


public class Image {

    static final int WIDTH = 0;
    static final int HEIGHT = 1;

    Bitmap bitmap; 
    short [] data;
    int lineLength; // in WORDS!
    int depth;

    static final int HEADER_SIZE = 8;

    static int hexToDec (char c) {
	if (c >= '0' && c <= '9') return ((int) c) - ((int) '0');
	if (c >= 'a' && c <= 'f') return 10 + ((int) c) - ((int) 'a');
	if (c >= 'A' && c <= 'F') return 10 + ((int) c) - ((int) 'A');
	throw new RuntimeException ("Illegal Char:"+c);
    }


   
    Image (int w, int h, int depth, byte [] data) {
	
	int byteW = (w+7)/8;
	
	if (byteW*h != data.length) 
	    throw new RuntimeException ("bw*h!=data.lengt");
	
	bitmap = new Bitmap ((short) byteW , data);
    }
	

    Image (int w, int h, int depth) {

	this.depth = depth;
	lineLength = (w * depth + 15) / 16;

	data = new short [HEADER_SIZE + h * lineLength];

	data [0] = (short) w;
	data [1] = (short) h;
	data [2] = (short) (lineLength * 2);
	data [3] = 0;
	data [4] = (short) ((depth << 8) + 1);
	data [5] = 0;
	data [6] = 0;
	data [7] = 0;

	bitmap = new Bitmap (data);
    }


    Image (int w, int h, int depth, String hexdata) {

	int byteW = (w+7)/8;
	
	if (byteW * h * 2 != hexdata.length ()) 
	    throw new RuntimeException ("bw*h*2!=data.lengt");
	
	byte [] data = new byte [hexdata.length() / 2];

	int cp = 0;
	int i = 0;
	while (cp < hexdata.length ()) {
	    data [i++] = (byte) (hexToDec (hexdata.charAt (cp)) * 16 
				 + hexToDec (hexdata.charAt (cp+1)));
	    cp += 2;
	}
	
	bitmap = new Bitmap ((short) byteW, data);
    }

    /*
    Image (Bitmap bitmap) {
	
	this.bitmap = bitmap;
    }
    */

    void setPixels (int x, int y, int w, int h,
		    ColorModel model, byte[] pixels,
		    int off, int scansize) {

	int dst = HEADER_SIZE + lineLength * y; 

	// ignore x, model, off, scansize;
	int i = 0;
	
	if (depth == 1) {
	    int border = w - 16;
	    int val;
	    while (i <= border) {
		val = 0;
		for (int j = 15; j >= 0; j--)
		    val |= pixels [i++] << j;
		data [dst++] = (short) val;
	    }
	}
	else if (depth == 4) {
	    int border = w - 4;
	    while (i <= border) {
		data [dst++] = (short) 
		    ((pixels [i] << 12)
		     + (pixels [i+1] << 8)
		     + (pixels [i+2] << 4)
		     + (pixels [i+3]));
		
		i += 4;
	    }
	}
	else if (depth == 8) {
	    int border = w - 2;
	    while(i <= border) {
		data [dst++] = (short) 
		    (((((int) pixels [i]) & 255) << 8)
		     + ((((int) pixels [i+1]) & 255)));
		
		i += 2;
	    }
	}
	else throw new RuntimeException ("depth currently unsupported!");
    } 


    public int getWidth (Object observer) {
	return data [WIDTH];
    } 


    public int getHeight (Object observer) {
	return data [HEIGHT];
    }
}

