/*
 * List.java 
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 *  2000-06-26 SH choice selection bug fixed
 *  2000-06-25 SH/MK SelectedItem Color changed
 *  2000-06-22 SH Changed to use ScrollManager
 *  2000-05-23 SH Event generation improved
 *  2000-05-20 SH deselect added, setSelectedIndex renamed to select
 *  2000-05-02 SH deselction event bug fixed 
 *  2000-03-03 MK remove added
 *  2000-03-01 SH setSelectedIndex bug fixed
 *  2000-02-17 MK/SH ItemSelectable implemented
 *  1999-12-14 SH removed double paint problem 
 *  1999-11-30 Version 0.21:
 *             - getMinimumSize changed (wg. Choice out of screen)
 *             - repaint added to removeAll
 *  1999-11-26 Version 0.2;  
 *             - getSelectedIndex added (bugrep. by Flemming Bregnvig)
 *  1999-11-07 Version number 0.11 released
 *	       -flickering while itemselection fixed
 *	       -list srolls now while dragging out of
 *	       -the list area
 *  1999-10-22 Version number 0.1 released
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */


package java.awt;

import java.awt.event.*;
import java.util.Vector;


public class List extends Component implements ItemSelectable {
    
    Vector elements = new Vector ();
    
    int sel = -1;
    int newSel = -1;
    int minW = 20;
    int lineH = Toolkit.defaultTextHeight;
    Choice choice;
    Menu menu;
    ScrollManager scrollManager;
    
    ItemListener il;
    
    public List () {
	scrollManager = new ScrollManager 
	    (this, ScrollManager.BORDER_SINGLE);
    }


    List (Choice choice) {
	this.choice = choice;
	scrollManager = new ScrollManager 
	    (this, ScrollManager.BORDER_SHADOW);
    }

    List (Menu menu) {
	this.menu = menu;
	scrollManager = new ScrollManager 
	    (this, ScrollManager.BORDER_SHADOW);
    }



    void addObject (Object item) {
	int iw = com.sun.kjava.Graphics.getWidth (item.toString ())+7;

	if (iw > minW) minW = iw;
	elements.addElement (item);
	doLayout ();
	repaint ();
    }
    

    public void add (String item) {
	addObject (item);
    }

    
    public void addItemListener (ItemListener l) {
	if (il != null) 
	    throw new TooManyListenersException ();
	
	il = l;
    }

 
    public Dimension getMinimumSize () {
	
	int mh = elements.size () * lineH 
	    + scrollManager.border;

	if (mh > 100) mh = 100;

	return new Dimension 
	    (minW + scrollManager.border, mh);
    }


    public int getSelectedIndex () {
	return sel;
    }


    public String getSelectedItem () {
	if (sel < 0 || sel >= elements.size ()) return null;
	return (String) elements.elementAt (sel);
    }


    public Object [] getSelectedObjects () {
	return new Object [] {elements.elementAt (sel)};
    }
    
    
    public Component findComponentAt (int px, int py) {
	return scrollManager.findComponentAt (px, py);
    }


    public void update (Graphics g) {
	paint (g);
    }
    

    public void paint (Graphics g) {
	
	scrollManager.paint (g);

	// draw list

	int i = scrollManager.yOffset / lineH;

	int ty = - (scrollManager.yOffset % lineH);
	int tx = 1 - scrollManager.xOffset;
	
	while ( ty < h) {
	    // XXX change in Graphics (baseline!)
	    
	    g.setColor (i == newSel ? SystemColor.activeCaption : Color.white);
	    g.fillRect (0, ty, scrollManager.viewPortW, lineH);

	    if (i < elements.size ()) {
		g.setColor (i == newSel ? Color.white : Color.black);
		g.drawString (elements.elementAt (i).toString (), 
			      tx, ty + Toolkit.defaultTextBaseline); 
	    }
	    
	    i++;
	    ty += lineH;
	}
    }


    public void processMouseEvent (MouseEvent me) {

	if (me.getID () == me.MOUSE_RELEASED) 
	    select (newSel);

	if (me.getID () != me.MOUSE_DRAGGED 
	    && me.getID () != me.MOUSE_PRESSED) return;

	int newNewSel = (scrollManager.yOffset + me.getY ()) 
	    / lineH;

	if (newNewSel < 0) newNewSel = 0;
	if (newNewSel >= elements.size ()) newNewSel = elements.size () -1;
	
	else if (newNewSel != newSel) {
	    newSel = newNewSel;

	    if (scrollManager.vBar != null) {
		int sv = newSel * lineH;

		if (sv < scrollManager.vBar.currValue)
		    scrollManager.vBar.currValue = sv;

		else if (sv > scrollManager.vBar.currValue 
			 + scrollManager.vBar.currVisible)

		    scrollManager.vBar.currValue = 
			sv - scrollManager.vBar.currVisible;
	    }
	    repaint ();
	}
    }


    public void removeAll () {
	elements.removeAllElements ();
	deselect (sel);
	minW = 20;
	doLayout ();
	repaint ();
    }


    public synchronized void doLayout () {  

	scrollManager.doLayout (minW, elements.size () * lineH);
    }

    
    public void remove (int position) {
	if (sel == position)	
	    deselect (sel);
	elements.removeElementAt (position);
	doLayout ();
	repaint ();
    }

    
    public void removeItemListener (ItemListener l) {
	if (l == il) il = null;
    }


    public void deselect (int old) {

	if (old != sel || old == -1 || old >= elements.size ()) return;
	
	newSel = -1;
	sel = -1;

	if (il != null)
	    il.itemStateChanged 
		(new ItemEvent 
		    (this, ItemEvent.ITEM_STATE_CHANGED, 
		     elements.elementAt (old), 
		     ItemEvent.DESELECTED));

	repaint ();
    }
    

    public void select (int index) {

	if (menu != null) {

	    if (menu.win != null) {
		menu.win.setVisible (false);
		menu.win.owner.menuBar.win.setVisible (false);
	    }
	    
	    if (index != -1) {
		
		MenuItem item = (MenuItem) elements.elementAt (index);
		if (item.al != null) 
		    item.al.actionPerformed 
			(new ActionEvent 
			    (item, ActionEvent.ACTION_PERFORMED, 
			     item.command == null 
			     ? item.label 
			     : item.command));
	    }
	    
	    return;
	}

	ItemSelectable source = this;
	
	if (choice != null) { 
	    if (choice.win != null) choice.win.setVisible (false);
	    //	    choice.repaint ();
	    source = choice;
	}
	

	if (index != sel) {
	    
	    if (choice != null) 
		choice.repaint ();
	    else if (newSel == sel) // setzen von aussen  
		repaint ();

	    sel = index;
	    newSel = sel;
	}

	if (il != null && index != -1)
	    il.itemStateChanged 
		(new ItemEvent 
		    (source, ItemEvent.ITEM_STATE_CHANGED, 
		     elements.elementAt (index), 
		     ItemEvent.SELECTED));
	
    }
}


